% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-show.r
\name{pretty_number}
\alias{pretty_number}
\alias{common_formatter}
\title{Common functions for formatting table cells}
\usage{
pretty_number(x, max_len = 20)

common_formatter(x, max_len = 20)
}
\arguments{
\item{x}{A vector of values to format.}

\item{max_len}{The maximum length for the formatted string.}
}
\value{
A character string with the formatted number. If the number cannot fit within the specified maximum length, scientific notation is used with reduced digits.

A character vector of the same length as x with formatted values. For numeric values, uses pretty_number() formatting. For non-numeric values, truncates strings longer than max_len and appends "..." if needed.
}
\description{
Common functions for formatting table cells

Common functions for formatting table cells
}
\details{
\code{pretty_number} : keep all digits if we can keep it within the width limit. Otherwise, use scientific notation to reduce length. If the number still cannot fit within the length limit, return the shortest result.

\code{common_formatter} : For numeric, call \code{pretty_number} to format the number. For non-numeric, truncate the string and append "..." if it exceeds the width limit.
}
\examples{
## Format a number
pretty_number(1234567890, max_len = 20)
pretty_number(1234567890, max_len = 8)
pretty_number(1234567890, max_len = 3)
## format character
common_formatter("this is a long string", max_len = 40)
common_formatter("this is a long string", max_len = 20)
}
\seealso{
\code{\link[=format_tbl]{format_tbl()}} for formatting tables
}
