% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patients.R
\name{readPatients.xl}
\alias{readPatients.xl}
\title{Converts a sample of patients in XLSX format into Unit Testing Definition JSON file.}
\usage{
readPatients.xl(
  filePath = NULL,
  testName = "test",
  outputPath = NULL,
  cdmVersion = "5.3",
  extraTable = FALSE
)
}
\arguments{
\item{filePath}{Path to the test patient data in Excel format. The Excel has sheets that represent tables from the OMOP-CDM, e.g. person, drug_exposure, condition_ocurrence, etc.}

\item{testName}{A name of the test population in character.}

\item{outputPath}{Path to write the test JSON files. If NULL, the files will be written at the project's testthat folder, i.e. tests/testthat/testCases.}

\item{cdmVersion}{cdm version, default "5.3".}

\item{extraTable}{TRUE or FALSE. If TRUE, non-standard tables will be included in the test CDM.}
}
\value{
A directory with the test JSON files with sample patients inside the project directory.
}
\description{
Converts a sample of patients in XLSX format into Unit Testing Definition JSON file.
}
\examples{
filePath <- system.file("extdata", "testPatientsRSV.xlsx", package = "TestGenerator")
readPatients.xl(filePath = filePath, outputPath = tempdir())

}
