% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.AdPaik.R
\name{confint.AdPaik}
\alias{confint.AdPaik}
\title{Extracts the Confidence Intervals for the Coefficients for the 'Adapted Paik et Al.' Model}
\usage{
\method{confint}{AdPaik}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{An S3 object of class \code{AdPaik}, returned by the main model function
(\code{AdPaikModel}). This object contains all the optimal parameter estimates.}

\item{parm}{A specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names.
Defaults to NULL, and all parameters are considered. Changing it is not supported for this model. It will be ignored.}

\item{level}{The confidence level required. Defaults to 0.95.}

\item{...}{Additional arguments to be passed to other methods.}
}
\value{
A named list containing the categories of the standard errors for the optimal parameters.
}
\description{
Extracts the confidence intervals for \eqn{\boldsymbol{\beta}} obtained with the
time-dependent frailty model proposed in the 'Adapted Paik et al.' framework.
}
\details{
The \code{confint.AdPaik} function extracts the standard errors for the beta coefficients from the
\code{ParametersCI} field in \code{object}.

The function validates the structure of \code{object} and ensures compatibility
with the expected model output. It throws an error if the object is malformed or
inconsistent.
}
\examples{
# Example using the 'Academic Dropout' dataset
data(data_dropout)

# Define the formula and time axis for the model
formula <- time_to_event ~ Gender + CFUP + cluster(group)
time_axis <- c(1.0, 1.4, 1.8, 2.3, 3.1, 3.8, 4.3, 5.0, 5.5, 5.8, 6.0)
eps <- 1e-10
categories_range_min <- c(-8, -2, eps, eps, eps)
categories_range_max <- c(-eps, 0, 1 - eps, 1, 10)

\donttest{
# Run the main model
result <- AdPaikModel(formula, data_dropout, time_axis,
                      categories_range_min, categories_range_max, TRUE)

# Extract the coefficients
confint(result)
}
}
