% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-fishery-statistics.R
\name{get_length_range}
\alias{get_length_range}
\title{Get length range from frequencies}
\usage{
get_length_range(frequency, length, type = "min")
}
\arguments{
\item{frequency}{Numeric vector of length frequencies.}

\item{length}{Numeric vector of corresponding lengths.}

\item{type}{Either "min" or "max" to specify which range to return.}
}
\value{
Minimum or maximum length value with frequency > 0.
}
\description{
Finds the minimum or maximum length with positive frequency.
}
\examples{
freq <- c(0, 0, 1, 2, 3, 4, 2, 1, 0)
lengths <- c(5, 6, 7, 8, 9, 10, 11, 12, 13)
min_length <- get_length_range(freq, lengths, type = "min")
max_length <- get_length_range(freq, lengths, type = "max")

}
