% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_timeunits}
\alias{check_timeunits}
\alias{assert_timeunits}
\title{Vérifie la conformité d'un objet TimeUnits}
\usage{
check_timeunits(x, frequency_ts, .var.name = checkmate::vname(x))

assert_timeunits(x, frequency_ts, add = NULL, .var.name = checkmate::vname(x))
}
\arguments{
\item{x}{un numérique qui représente le time units de}

\item{frequency_ts}{un entier qui vaut \code{4L} (ou \code{4.0}) pour les séries
trimestrielles et \code{12L} (ou \code{12.0}) pour les séries mensuelles.}

\item{.var.name}{Nom de l'objet à vérifier pour afficher dans les messages}

\item{add}{Collection pour stocker les messages d'erreurs (Default is NULL)}
}
\value{
En sortie la fonction retourne l'objet \code{x} de manière invisible ou
une erreur.
}
\description{
La fonction \code{assert_timeunits} vérifie qu'un objet est un
TimeUnits.
}
\details{
Un objet de type TimeUnits est un numérique qui désigne l'année et la période
en cours avec ses décimales.
Ainsi pour une série temporelle mensuelle, \code{2020.5} représente la moitié de
l'année donc juillet 2020 et s'écrit \code{c(2020L, 7L)} au format date_ts.

Selon le préfixe de la fonction :
\itemize{
\item si le check réussi :
\itemize{
\item la fonction \code{assert_timeunits} retourne l'objet \code{x} de manière
invisible;
\item la fonction \code{check_timeunits} retourne le booléen \code{TRUE}.
}
\item si le check échoue :
\itemize{
\item la fonction \code{assert_timeunits} retourne un message d'erreur;
\item la fonction \code{check_timeunits} retourne une chaîne de caractère
signalant le problème.
}
}
}
\examples{

assert_timeunits(2020.5, frequency_ts = 12L)
assert_timeunits(2020.5, frequency_ts = 4L)
assert_timeunits(2023., frequency_ts = 12L)

assert_timeunits(2000. + 5. / 12.0, frequency_ts = 12L)
assert_timeunits(2015. + 3. / 4.0, frequency_ts = 4L)

check_timeunits(2020.5, frequency_ts = 12L)
check_timeunits(2015. + 3. / 4.0, frequency_ts = 4L)

# Avec erreur

check_timeunits(list(1.), frequency_ts = 12L)
check_timeunits(2000., frequency_ts = 1L)

}
