% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jackknife.R
\name{JackLabels}
\alias{JackLabels}
\title{Label nodes with jackknife support values}
\usage{
JackLabels(
  tree,
  jackTrees,
  plot = TRUE,
  add = FALSE,
  adj = 0,
  col = NULL,
  frame = "none",
  pos = 2L,
  showFraction = FALSE,
  format = "character",
  ...
)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{jackTrees}{A list or \code{multiPhylo} object containing trees generated
by \code{\link[=Resample]{Resample()}} or \code{\link[=Jackknife]{Jackknife()}}.}

\item{plot}{Logical specifying whether to plot results; if \code{FALSE},
returns blank labels for nodes near the root that do not correspond to a
unique split.}

\item{add}{Logical specifying whether to add the labels to an existing
plot.}

\item{adj, col, frame, pos, \dots}{Parameters to pass to \code{nodelabels()}.}

\item{showFraction}{Logical specifying whether to also annotate nodes
with the fraction of replicates that were decisive for the split.}

\item{format}{Character specifying return format.
\code{"character"} returns a character string suitable to add to the \code{node.labels}
attribute of a tree;
"numeric" returns numeric values suitable for further analysis.}
}
\value{
A named vector specifying the proportion of jackknife iterations
consistent with each node in \code{tree}, as plotted.
If \code{format = "character"}, blank entries are included corresponding to nodes
that do not require labels, such that the return value is in the format
required by \code{phylo$node.label}.
If multiple trees are specified per iteration, the return value has an
attribute \code{decisive} listing, for each entry in the return value, how many
iterations were decisive for that split.
}
\description{
\code{JackLabels()} produces a list of node labels denoting split support from
a set of resampled trees, optionally printing them on a tree.
}
\details{
If an element of \code{jackTrees} contains multiple trees, then the iteration is
counted as supporting a split if all trees contain the split, and as
contradicting the split if no trees contain it.  If a split is only present
in a subset of trees, that iteration is considered not to be decisive, and
is ignored when calculating the support for that split.
}
\examples{
library("TreeTools", quietly = TRUE) # for as.phylo

# jackTrees will usually be generated with Jackknife() or Resample(),
# but for simplicity:
jackTrees <- as.phylo(1:100, 8)

tree <- as.phylo(0, 8)
JackLabels(tree, jackTrees)

tree$node.label <- JackLabels(tree, jackTrees, plot = FALSE)

# Write the labelled tree to screen
ape::write.tree(tree)

# Write labelled trees to a nexus file:
# write.nexus(tree, file = filename)
}
\seealso{
Generate trees by jackknife resampling using \code{\link[=Resample]{Resample()}} for standard
parsimony searches, or \code{\link[=Jackknife]{Jackknife()}} for custom search criteria.

Other split support functions: 
\code{\link{Jackknife}()},
\code{\link{MaximizeParsimony}()},
\code{\link{PresCont}()},
\code{\link{SiteConcordance}}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split support functions}
