% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cmat.calc.R
\name{Cmat.calc}
\alias{Cmat.calc}
\title{Cross Autocorrelation Wavelet Inner Product Matrix Calculation}
\usage{
Cmat.calc(
  J,
  gen.filter.number = 1,
  an.filter.number = 1,
  gen.family = "DaubExPhase",
  an.family = "DaubExPhase"
)
}
\arguments{
\item{J}{The dimension of the matrix required. Should be a positive integer.}

\item{gen.filter.number}{The index of the generating wavelet used to compute
the inner product matrix.}

\item{an.filter.number}{The index of the analysing wavelet used to compute
the inner product matrix.}

\item{gen.family}{The family of generating wavelet used to compute the inner
product matrix.}

\item{an.family}{The family of analysing wavelet used to compute the inner
product matrix.}
}
\value{
A J-dimensional square matrix giving the cross inner product
autocorrelation wavelet matrix.
}
\description{
Internal function to compute the cross autocorrelation matrix of inner products.
This is not intended for general use by regular users of the package.
}
\details{
Computes the cross inner product matrix of the discrete
non-decimated autocorrelation wavelets. This matrix is used to correct the
wavelet periodogram analysed using a different wavelet to the wavelet that
is assumed to generate the time series. The matrix returned is the one
denoted \eqn{C^{(0,1)}} in McGonigle et al. (2022).
}
\references{
McGonigle, E. T., Killick, R., and Nunes, M. (2022). Trend
locally stationary wavelet processes. \emph{Journal of Time Series
Analysis}, 43(6), 895-917.
}
\seealso{
\link{TLSW}
}
\keyword{internal}
