% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/trial_sequence.R
\name{load_expanded_data}
\alias{load_expanded_data}
\alias{load_expanded_data,trial_sequence-method}
\title{Method to read, subset and sample expanded data}
\usage{
load_expanded_data(
  object,
  p_control = NULL,
  period = NULL,
  subset_condition = NULL,
  seed = NULL
)

\S4method{load_expanded_data}{trial_sequence}(
  object,
  p_control = NULL,
  period = NULL,
  subset_condition = NULL,
  seed = NULL
)
}
\arguments{
\item{object}{An object of class \linkS4class{trial_sequence}.}

\item{p_control}{Probability of selecting a control, \code{NULL} for no sampling (default).}

\item{period}{An integerish vector of non-zero length to select trial period(s) or \code{NULL} (default) to
select all trial periods.}

\item{subset_condition}{A string or \code{NULL} (default). \code{subset_condition} will be translated to a call
(in case the expanded data is saved as a data.table or in the csv format) or to a SQL-query
(in case the expanded data is saved as a duckdb file).

The operators \verb{"==", "!=", ">", ">=", "<", "<=", \%in\%", "&", "|"} are supported.
Numeric vectors can be written as \code{c(1, 2, 3)} or \code{1:3}. Variables are not supported.

\emph{Note}: Make sure numeric vectors written as \code{1:3} are surrounded by spaces, e.g. \code{a \%in\% c( 1:4 , 6:9 )},
otherwise the code will fail.}

\item{seed}{An integer seed or \code{NULL} (default).

\emph{Note}: The same seed will return a different result depending on the class of the \linkS4class{te_datastore}
object contained in the \linkS4class{trial_sequence} object.}
}
\value{
An updated \linkS4class{trial_sequence} object, the data is stored in slot \verb{@outcome_data}
as a \linkS4class{te_outcome_data} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
This method is used on \linkS4class{trial_sequence} objects to read, subset and sample expanded data.
}
\examples{
# create a trial_sequence-class object
trial_itt_dir <- file.path(tempdir(), "trial_itt")
dir.create(trial_itt_dir)
trial_itt <- trial_sequence(estimand = "ITT") |>
  set_data(data = data_censored) |>
  set_outcome_model(adjustment_terms = ~ x1 + x2)

trial_itt_csv <- set_expansion_options(
  trial_itt,
  output = save_to_csv(file.path(trial_itt_dir, "trial_csvs")),
  chunk_size = 500
) |>
  expand_trials()

# load_expanded_data default behaviour returns all trial_periods and doesn't sample
load_expanded_data(trial_itt_csv)

# load_expanded_data can subset the data before sampling
load_expanded_data(
  trial_itt_csv,
  p_control = 0.2,
  period = 1:20,
  subset_condition = "followup_time \%in\% 1:20 & x2 < 1",
)

# delete after use
unlink(trial_itt_dir, recursive = TRUE)
}
