% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahalanobis_distance.R
\name{mahalanobis_distance}
\alias{mahalanobis_distance}
\title{mahalanobis_distance}
\usage{
mahalanobis_distance(value, sample_mean, sample_covariance_matrix)
}
\arguments{
\item{value}{Point to calculate the mahalanobis_distance}

\item{sample_mean}{Sample mean}

\item{sample_covariance_matrix}{Sample Covariance Matrix}
}
\value{
Mahalanobis distance associated to the point
}
\description{
Calculates the mahalanobis_distance given the input data
}
\examples{
inputData = t(matrix(c(3,2,3.5,12,4.7,4.1,5.2,
4.9,7.1,6.1,6.2,5.2,14,5.3),2,7,dimnames=list(c("r","d"))));
inputData = data.frame(inputData);
inputData = as.matrix(inputData);
sampleMeans = c();
for(i in 1:ncol(inputData)){
  column = inputData[,i];
  calculatedMean = sum(column)/length(column);
  print(sprintf("Calculated mean for column \%d: \%f", i, calculatedMean))
  sampleMeans = c(sampleMeans, calculatedMean);
}
covariance_matrix = cov(inputData);
distance = mahalanobis_distance(inputData[3,], sampleMeans, covariance_matrix);

}
\author{
Andres Missiego Manjon
}
