% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_gene_pw_cor.R
\name{vis_gene_pw_cor}
\alias{vis_gene_pw_cor}
\title{Visualize Correlation between Gene and Pathway signature Score}
\usage{
vis_gene_pw_cor(
  Gene = "TP53",
  data_type = "mRNA",
  pw_name = "HALLMARK_ADIPOGENESIS",
  cancer_choose = "GBM",
  use_regline = TRUE,
  cor_method = "spearman",
  use_all = FALSE,
  alpha = 0.5,
  color = "#000000",
  filter_tumor = TRUE,
  opt_pancan = .opt_pancan
)
}
\arguments{
\item{Gene}{a molecular identifier (e.g., "TP53") or a formula
specifying genomic signature ("TP53 + 2 * KRAS - 1.3 * PTEN").}

\item{data_type}{choose gene profile type, including
"mRNA", "transcript", "protein", "mutation", "cnv", "methylation", "miRNA".}

\item{pw_name}{the queried Pathway name, see the supported pathway from 'load("toil_sig_score")'default is NULL}

\item{cancer_choose}{select cancer cohort(s)}

\item{use_regline}{if TRUE, add regression line.}

\item{cor_method}{select correlation coefficient (pearson/spearman)}

\item{use_all}{use all sample, default FALSE.}

\item{alpha}{dot alpha.}

\item{color}{dot color.}

\item{filter_tumor}{whether use tumor sample only, default TRUE}

\item{opt_pancan}{specify one dataset for some molercular profiles}
}
\value{
a \code{ggplot} object or  dataframe
}
\description{
Visualize Correlation between Gene and Pathway signature Score
}
\examples{
\dontrun{
vis_gene_pw_cor(
  Gene = "TP53", data_type = "mRNA",
  pw_name = "HALLMARK_ADIPOGENESIS",
  cancer_choose = "BRCA"
)
}
}
