% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cw_d_uvb.R
\name{cw_uvb}
\alias{cw_uvb}
\title{Calculate CW-D-UVB dose}
\usage{
cw_uvb(
  data,
  date,
  longitude,
  latitude,
  temis_path = getwd(),
  h = 35,
  days = 135,
  region = "europe"
)
}
\arguments{
\item{data}{data frame containing sample IDs, date, longitude, and latitude}

\item{date}{A date vector, usually date of assessment or recruitment.}

\item{longitude}{A numeric vector of longitude values.}

\item{latitude}{A numeric vector of latitude values.}

\item{temis_path}{Path to TEMIS UV files downloaded using \link{temis_uvdvc}. Default is current directory.}

\item{h}{Half-life of vitamin D UV in the body in days, default is 35 days.}

\item{days}{Number of days prior to sampling over which to calculate the CW-D-UVB dose, default is 135 days.}

\item{region}{Region of TEMIS data required, options are "europe" (default) or "world".}
}
\value{
A numeric vector of CW-D-UVB dose estimates.
}
\description{
This function calculates cumulative and weighted vitamin D UVB (CW-D-UVB) dose based on a given index date, longitude, and latitude.
Vitamin D accumulates during the summer months, and is used up in the winter - this estimate correlates to measured vitamin D levels.
The dose is calculated over 135 days prior to the date of assessment provided and weighted to that days closer to the date contribute more to the final estimate.
See O'Sullivan et al., 2017 DOI: 10.3945/jn.116.244079 for more details.
}
\examples{
#uses sample TEMIS file
mysample <- data.frame(id = c("id000016"),
        date = as.Date(c("2010-08-04")),
        longitude = c(-2.10),
        latitude = c(50.5))
uvb_example <- system.file("extdata", "uvb_example", package="UVdose")
cw_uvb(mysample, date, longitude, latitude, temis_path = uvb_example)

}
\references{
O'Sullivan et al., 2017. Ambient UVB Dose and Sun Enjoyment Are Important Predictors of Vitamin D Status in an Older Population. J Nutr. doi: 10.3945/jn.116.244079. PMID: 28331054.
}
