% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runVICatMixAvg.R
\name{runVICatMixAvg}
\alias{runVICatMixAvg}
\title{runVICatMixAvg}
\usage{
runVICatMixAvg(
  data,
  K,
  alpha,
  maxiter = 2000,
  tol = 5e-08,
  inits = 25,
  loss = "VoIcomp",
  parallel = FALSE,
  cores = getOption("mc.cores", 2L),
  verbose = FALSE
)
}
\arguments{
\item{data}{A data frame or data matrix with N rows of observations, and P
columns of covariates.}

\item{K}{Maximum number of clusters desired. Must be an integer greater than 1.}

\item{alpha}{The Dirichlet prior parameter. Recommended to set this to a
number < 1. Must be > 0.}

\item{maxiter}{The maximum number of iterations for the algorithm. Default is
2000.}

\item{tol}{A convergence parameter. Default is 5x10^-8.}

\item{inits}{The number of initialisations included in the co-clustering
matrix. Default is 25.}

\item{loss}{The loss function to be used with the co-clustering matrix.
Default is VoIcomp. Options are "VoIavg", "VoIcomp" and "medv".}

\item{parallel}{Logical value indicating whether to run initialisations in
parallel. Default is FALSE.}

\item{cores}{User can specify number of cores for parallelisation if parallel
= TRUE. Package automatically uses the user's parallel backend if one has
already been registered.}

\item{verbose}{Default FALSE. Set to TRUE to output ELBO values for each iteration.}
}
\value{
A list with the following components: (maxNCat refers to the maximum
  number of categories for any covariate in the data)
  \item{labels_avg}{A numeric N-vector listing the cluster assignments for 
  the observations in the averaged model.}
  \item{init_results}{A list where each entry is the cluster assignments for 
  one of the initialisations included in the model averaging.}
}
\description{
An extension of `runVICatMix` to incorporate model averaging/summarisation
over multiple initialisations.
}
\examples{
# example code
\donttest{set.seed(20)
generatedData <- generateSampleDataBin(500, 4, c(0.1, 0.2, 0.3, 0.4), 100, 0)
result <- runVICatMixAvg(generatedData$data, 10, 0.01, inits = 10)

print(result$labels_avg)}



}
\seealso{
\code{\link{runVICatMix}}
}
