% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeRobust.R
\name{imputeRobust}
\alias{imputeRobust}
\title{Robust imputation}
\usage{
imputeRobust(
  form,
  data,
  boot = TRUE,
  robustboot = "stratified",
  method = "MM",
  takeAll = TRUE,
  alpha = 0.75,
  uncert = "pmm",
  family = "Gaussian",
  value_back = "all"
)
}
\arguments{
\item{form}{Model formulas as a list.}

\item{data}{Data set to impute}

\item{boot}{Accounting for model uncertainty with a classical bootstrap,
Default: TRUE}

\item{robustboot}{Accounting for model uncertainty with robust bootstrap
methods, Default: 'stratified'}

\item{method}{Imputation method, Default: 'MM'}

\item{takeAll}{Missing values are intialized when TRUE, Default: TRUE}

\item{alpha}{Relative size of good data points. Used for the robust
bootstrap methods, Default: 0.75}

\item{uncert}{Imputation uncertainty method, Default: 'pmm'}

\item{family}{Not supported and ignored. Foreseen for future versions, Default: 'Gaussian'}

\item{value_back}{Only observations with imputed values as return object (ymiss),
or the whole data set, Default: 'all'}
}
\value{
Imputed data set.
}
\description{
Multiple imputation using classical and robust methods
accounting for model and imputation uncertainty.
}
\details{
Complex formulas can be provided for each variable in
your data set.
}
\examples{
\dontrun{
if(interactive()){
 #EXAMPLE1
 }
}
}
\seealso{
\code{\link[VIM]{initialise}}
\code{\link[robustbase]{lmrob}}
\code{\link[mgcv]{gam}}
\code{\link[pdist]{pdist}}
}
