% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy_RR.R
\name{entropy_RR}
\alias{entropy_RR}
\title{Calculate Entropy for Amino Acid Sequences}
\usage{
entropy_RR(alignment)
}
\arguments{
\item{alignment}{An `AAStringSet` object containing the aligned amino acid sequences.}
}
\value{
A numeric vector representing the entropy values for each position in the alignment.
}
\description{
This function calculates the entropy of a set of amino acid sequences. 
It is used to evaluate the diversity of sequences in a given alignment.
}
\details{
The entropy is calculated based on the frequency of amino acids at each position in the alignment.
Higher entropy indicates greater variability at that position.
}
\examples{
# Example usage:
library(Biostrings)
sequences <- AAStringSet(c("ACDEFGHIK", "ACDEFGHIK", "ACDEFGHIK"))
entropy_values <- entropy_RR(sequences)
print(entropy_values)
}
