% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_K.R
\name{estimate_k_modes}
\alias{estimate_k_modes}
\title{Estimation of Intrinsic Mode Function (IMF) Number in Variational Mode Decomposition}
\usage{
estimate_k_modes(
  signal_1d,
  cor_thresh,
  default_vmd_params,
  min_K = 2,
  seed = 1,
  verbose = FALSE
)
}
\arguments{
\item{signal_1d}{a numeric vector specifying the 1-dimensional input signal}

\item{cor_thresh}{a numeric value specifying the minimum (positive or negative) correlation coefficient threshold where decomposition will be stopped (a value between 0.0 and 1.0)}

\item{default_vmd_params}{a list of parameters consisting of the (remaining) Variational Mode Decomposition default parameters (except for 'data' and 'K')}

\item{min_K}{a numeric value specifying the minimum value of the K (modes) parameter (from which decomposition starts)}

\item{seed}{a numeric value specifying the seed (for reproducibility purposes)}

\item{verbose}{a boolean. If TRUE then information will be printed in the console}
}
\value{
a numeric value specifying the optimal K parameter
}
\description{
Estimation of Intrinsic Mode Function (IMF) Number in Variational Mode Decomposition
}
\details{
Correlation Coefficient Method:
\itemize{
\item Correlation coefficient (CC) between the mode components and the original signal will be obtained. Decomposition will be stopped when the minimum correlation coefficient is less than the given threshold, and then the value of K will be determined
}
}
\examples{

\dontrun{

require(VMDecomp)
data(arrhythmia)

default_vmd_params = list(alpha = 2000,
                          tau = 0,
                          DC = FALSE,
                          init = 1,
                          tol = 1e-6)

res_k = estimate_k_modes(signal_1d = arrhythmia[['MLII']],
                         cor_thresh = 0.1,
                         default_vmd_params = default_vmd_params,
                         min_K = 2,
                         seed = 1,
                         verbose = TRUE)
res_k
}
}
\references{
https://doi.org/10.1155/2020/8304903
}
