% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiCopSelect.R
\name{BiCopSelect}
\alias{BiCopSelect}
\title{Selection and Maximum Likelihood Estimation of Bivariate Copula Families}
\usage{
BiCopSelect(
  u1,
  u2,
  familyset = NA,
  selectioncrit = "AIC",
  indeptest = FALSE,
  level = 0.05,
  weights = NA,
  rotations = TRUE,
  se = FALSE,
  presel = TRUE,
  method = "mle"
)
}
\arguments{
\item{u1, u2}{Data vectors of equal length with values in \eqn{[0,1]}.}

\item{familyset}{Vector of bivariate copula families to select from.
The vector has to include at least one bivariate copula
family that allows for positive and one that allows for negative dependence.
If \code{familyset = NA} (default), selection among all possible families is
performed. If a vector of negative numbers is provided, selection among all
but \code{abs(familyset)} families is performed. Coding of bivariate copula
families: \cr
\code{0} = independence copula \cr
\code{1} = Gaussian copula \cr
\code{2} = Student t copula (t-copula) \cr
\code{3} = Clayton copula \cr
\code{4} = Gumbel copula \cr
\code{5} = Frank copula \cr
\code{6} = Joe copula \cr
\code{7} = BB1 copula \cr
\code{8} = BB6 copula \cr
\code{9} = BB7 copula \cr
\code{10} = BB8 copula \cr
\code{13} = rotated Clayton copula (180 degrees; \verb{survival Clayton'') \\cr `14` = rotated Gumbel copula (180 degrees; }survival Gumbel'') \cr
\code{16} = rotated Joe copula (180 degrees; \verb{survival Joe'') \\cr `17` = rotated BB1 copula (180 degrees; }survival BB1'')\cr
\code{18} = rotated BB6 copula (180 degrees; \verb{survival BB6'')\\cr `19` = rotated BB7 copula (180 degrees; }survival BB7'')\cr
\code{20} = rotated BB8 copula (180 degrees; ``survival BB8'')\cr
\code{23} = rotated Clayton copula (90 degrees) \cr
`24` = rotated Gumbel copula (90 degrees) \cr
`26` = rotated Joe copula (90 degrees) \cr
`27` = rotated BB1 copula (90 degrees) \cr
`28` = rotated BB6 copula (90 degrees) \cr
`29` = rotated BB7 copula (90 degrees) \cr
`30` = rotated BB8 copula (90 degrees) \cr
`33` = rotated Clayton copula (270 degrees) \cr
`34` = rotated Gumbel copula (270 degrees) \cr
`36` = rotated Joe copula (270 degrees) \cr
`37` = rotated BB1 copula (270 degrees) \cr
`38` = rotated BB6 copula (270 degrees) \cr
`39` = rotated BB7 copula (270 degrees) \cr
`40` = rotated BB8 copula (270 degrees) \cr
`104` = Tawn type 1 copula \cr
`114` = rotated Tawn type 1 copula (180 degrees) \cr
`124` = rotated Tawn type 1 copula (90 degrees) \cr
`134` = rotated Tawn type 1 copula (270 degrees) \cr
`204` = Tawn type 2 copula \cr
`214` = rotated Tawn type 2 copula (180 degrees) \cr
`224` = rotated Tawn type 2 copula (90 degrees) \cr
`234` = rotated Tawn type 2 copula (270 degrees) \cr}

\item{selectioncrit}{Character indicating the criterion for bivariate copula
selection. Possible choices: \code{selectioncrit = "AIC"} (default),
\code{"BIC"}, or \code{"logLik"}.}

\item{indeptest}{Logical; whether a hypothesis test for the independence of
\code{u1} and \code{u2} is performed before bivariate copula selection
(default: \code{indeptest = FALSE}; see \code{\link[=BiCopIndTest]{BiCopIndTest()}}).  The
independence copula is chosen if the null hypothesis of independence cannot
be rejected.}

\item{level}{Numeric; significance level of the independence test (default:
\code{level = 0.05}).}

\item{weights}{Numerical; weights for each observation (optional).}

\item{rotations}{If \code{TRUE}, all rotations of the families in
\code{familyset} are included (or subtracted).}

\item{se}{Logical; whether standard error(s) of parameter estimates is/are
estimated (default: \code{se = FALSE}).}

\item{presel}{Logical; whether to exclude families before fitting based on
symmetry properties of the data. Makes the selection about 30\% faster
(on average), but may yield slightly worse results in few special cases.}

\item{method}{indicates the estimation method: either maximum
likelihood estimation (\code{method = "mle"}; default) or inversion of
Kendall's tau (\code{method = "itau"}). For \code{method = "itau"} only
one parameter families and the Student t copula can be used (\verb{family = 1,2,3,4,5,6,13,14,16,23,24,26,33,34} or \code{36}). For the t-copula,
\code{par2} is found by a crude profile likelihood optimization over the
interval (2, 10].}
}
\value{
An object of class \code{\link[=BiCop]{BiCop()}}, augmented with the following
entries:
\item{se, se2}{standard errors for the parameter estimates (if
\code{se = TRUE},}
\item{nobs}{number of observations,}
\item{logLik}{log likelihood}
\item{AIC}{Akaike's Informaton Criterion,}
\item{BIC}{Bayesian's Informaton Criterion,}
\item{emptau}{empirical value of Kendall's tau,}
\item{p.value.indeptest}{p-value of the independence test.}
}
\description{
This function selects an appropriate bivariate copula family for given
bivariate copula data using one of a range of methods. The corresponding
parameter estimates are obtained by maximum likelihood estimation.
}
\details{
Copulas can be selected according to the Akaike and Bayesian Information
Criteria (AIC and BIC, respectively). First all available copulas are fitted
using maximum likelihood estimation. Then the criteria are computed for all
available copula families (e.g., if \code{u1} and \code{u2} are negatively
dependent, Clayton, Gumbel, Joe, BB1, BB6, BB7 and BB8 and their survival
copulas are not considered) and the family with the minimum value is chosen.
For observations \eqn{u_{i,j},\ i=1,...,N,\ j=1,2,}{u_{i,j}, i=1,...,N,\
j=1,2,} the AIC of a bivariate copula family \eqn{c} with parameter(s)
\eqn{\boldsymbol{\theta}} is defined as \deqn{AIC := -2 \sum_{i=1}^N
\ln[c(u_{i,1},u_{i,2}|\boldsymbol{\theta})] + 2k, }{ AIC := -2 \sum_{i=1}^N
ln[c(u_{i,1},u_{i,2}|\theta)] + 2k, } where \eqn{k=1} for one parameter
copulas and \eqn{k=2} for the two parameter t-, BB1, BB6, BB7 and BB8
copulas. Similarly, the BIC is given by \deqn{BIC := -2 \sum_{i=1}^N
\ln[c(u_{i,1},u_{i,2}|\boldsymbol{\theta})] + \ln(N)k. }{ BIC := -2
\sum_{i=1}^N ln[c(u_{i,1},u_{i,2}|\theta)] + ln(N)k. } Evidently, if the BIC
is chosen, the penalty for two parameter families is stronger than when
using the AIC.

Additionally a test for independence can be performed beforehand.
}
\note{
For a comprehensive summary of the fitted model, use
\code{summary(object)}; to see all its contents, use \code{str(object)}.

The parameters of the Student t and BB copulas are restricted (see
defaults in \code{\link[=BiCopEst]{BiCopEst()}} to avoid being to close to their limiting
cases.
}
\examples{
## Example 1: Gaussian copula with large dependence parameter
par <- 0.7
fam <- 1
dat1 <- BiCopSim(500, fam, par)
# select the bivariate copula family and estimate the parameter(s)
cop1 <- BiCopSelect(dat1[, 1], dat1[, 2], familyset = 1:10,
                    indeptest = FALSE, level = 0.05)
cop1  # short overview
summary(cop1)  # comprehensive overview
str(cop1)  # see all contents of the object

## Example 2: Gaussian copula with small dependence parameter
par <- 0.01
fam <- 1
dat2 <- BiCopSim(500, fam, par)
# select the bivariate copula family and estimate the parameter(s)
cop2 <- BiCopSelect(dat2[, 1], dat2[, 2], familyset = 0:10,
                    indeptest = TRUE, level = 0.05)
summary(cop2)

## Example 3: empirical data
data(daxreturns)
cop3 <- BiCopSelect(daxreturns[, 1], daxreturns[, 4], familyset = 0:10)
summary(cop3)

}
\references{
Akaike, H. (1973). Information theory and an extension of the
maximum likelihood principle. In B. N. Petrov and F. Csaki (Eds.),
Proceedings of the Second International Symposium on Information Theory
Budapest, Akademiai Kiado, pp. 267-281.

Brechmann, E. C. (2010). Truncated and simplified regular vines and their
applications. Diploma thesis, Technische Universitaet Muenchen.\cr
\url{https://mediatum.ub.tum.de/?id=1079285}.

Manner, H. (2007). Estimation and model selection of copulas with an
application to exchange rates. METEOR research memorandum 07/056, Maastricht
University.

Schwarz, G. E. (1978). Estimating the dimension of a model. Annals of
Statistics 6 (2), 461-464.
}
\seealso{
\code{\link[=BiCop]{BiCop()}},
\code{\link[=BiCopEst]{BiCopEst()}},
\code{\link[=RVineStructureSelect]{RVineStructureSelect()}},
\code{\link[=RVineCopSelect]{RVineCopSelect()}},
\code{\link[=BiCopIndTest]{BiCopIndTest()}},
}
\author{
Eike Brechmann, Jeffrey Dissmann, Thomas Nagler
}
