% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Children.R
\name{Children}
\alias{Children}
\title{Generates Individual Fertility Histories}
\usage{
Children(dat0, rates, mort = NULL)
}
\arguments{
\item{dat0}{Data frame with data on individual members of the virtual population (dLH format)}

\item{rates}{Mortality and fertility rates. The object 'rates' is produced by the function Getrates().}

\item{mort}{Presence or absence of mortality (optional). Default: mortality is present (mort=TRUE). If mortality is absent, set mort=FALSE.}
}
\value{
List object with two components: 
\item{data}{Data frame with updated information on members of the virtual population}
\item{dch}{Data frame with information on children}
}
\description{
Builds individual fertility histories from conditional fertility rates. Children() uses the function Sim_bio().
}
\examples{
# The example generates data on children of the first 10 female members of 
# the first generation of the virtual population.
utils::data(dLH,package="VirtualPop")
utils::data(rates,package="VirtualPop")
dat0 <- dLH[dLH$sex=="Female" & dLH$gen==1,][1:10,]
out <- VirtualPop::Children(dat0=dat0,rates=rates)

}
