% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShadowHist.R
\name{ShadowHist}
\alias{ShadowHist}
\title{Plot a Shadow Histogram Plot}
\usage{
ShadowHist(
  frm,
  xvar,
  condvar,
  title,
  ...,
  ncol = 1,
  monochrome = FALSE,
  palette = "Dark2",
  fillcolor = "darkblue",
  bins = 30,
  binwidth = NULL
)
}
\arguments{
\item{frm}{data frame to get values from.}

\item{xvar}{name of the primary continuous variable}

\item{condvar}{name of conditioning variable (categorical variable, controls faceting).}

\item{title}{title to place on plot.}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{ncol}{numeric: number of columns in facet_wrap.}

\item{monochrome}{logical: if TRUE, all facets filled with same color}

\item{palette}{character: if monochrome==FALSE, name of brewer color palette (can be NULL)}

\item{fillcolor}{character: if monochrome==TRUE, name of fill color}

\item{bins}{number of bins. Defaults to thirty.}

\item{binwidth}{width of the bins. Overrides bins.}
}
\value{
a ggplot2 histogram plot
}
\description{
Plot a histogram of a continuous variable \code{xvar},
faceted on a categorical conditioning variable, \code{condvar}. Each faceted plot
also shows a "shadow plot" of the unconditioned histogram for comparison.
}
\details{
Currently supports only the \code{bins} and \code{binwidth} arguments (see \code{\link[ggplot2]{geom_histogram}}),
but not the \code{center}, \code{boundary}, or \code{breaks} arguments.

By default, the facet plots are arranged in a single column. This can be changed
with the optional \code{ncol} argument.

If \code{palette} is NULL, and \code{monochrome} is FALSE, plot colors will be chosen from the default ggplot2 palette. Setting \code{palette} to NULL
allows the user to choose a non-Brewer palette, for example with \code{\link[ggplot2:scale_manual]{scale_fill_manual}}.
For consistency with previous releases, \code{ShadowHist} defaults to \code{monochrome = FALSE}, while
\code{\link{ShadowPlot}} defaults to \code{monochrome = TRUE}.

Please see here for some interesting discussion \url{https://drsimonj.svbtle.com/plotting-background-data-for-groups-with-ggplot2}.
}
\examples{

if (requireNamespace('data.table', quietly = TRUE)) {
	# don't multi-thread during CRAN checks
		data.table::setDTthreads(1)
}

ShadowHist(iris, "Petal.Length", "Species",
           title = "Petal Length distribution by Species")

if (FALSE) {
# make all the facets the same color
ShadowHist(iris, "Petal.Length", "Species",
           monochrome=TRUE,
           title = "Petal Length distribution by Species")
}

}
