% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varHR.R
\encoding{UTF-8}
\name{varHAJ}
\alias{varHAJ}
\title{Hajek-Rosen variance estimator}
\usage{
varHAJ(y, pik, s)
}
\arguments{
\item{y}{vector of size \eqn{n} that represent the variable of interest.}

\item{pik}{vector of the inclusion probabilities. The length should be equal to \eqn{n}.}

\item{s}{index vector of size \eqn{n} with elements equal to the selected units.}
}
\value{
A number, the variance.
}
\description{
Estimator of the variance of the Horvitz-Thompson estimator. It is based on the variance estimator of the conditional Poisson sampling design. See Tillé (2020, Chapter 5) for more informations.
}
\details{
The function computes the following quantity :

\deqn{v_{HAJ}(\widehat{Y}_{HT}) = \frac{n}{n-1} \sum_{k\in S} (1-\pi_k)\left( \frac{y_k}{\pi_k}-\frac{ \sum_{l\in S} (1-\pi_k)/\pi_k }{\sum_{l\in S} (1-\pi_k) } \right)^2 .}
 
This estimator is well-defined for maximum entropy sampling design and use only inclusion probabilities of order one.
}
\references{
Tillé, Y. (2020). Sampling and estimation from finite populations. New York: Wiley
}
