% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Computation.r
\name{incentivizeWoM}
\alias{incentivizeWoM}
\title{Calculates the impact of incentivizing WoM communication}
\usage{
incentivizeWoM(campaign, expProb, rewardCost = 0, keepStartPrice = FALSE)
}
\arguments{
\item{campaign}{Word-of-Mouth campaign as instance of class \code{WoMCampaign}.}

\item{expProb}{Expected forward probability when incentivizing WoM.}

\item{rewardCost}{Cost per consumer acquired through the incentivization strategy.}

\item{keepStartPrice}{Logical value indicating whether or not (default) the optimized price for the start forward probability will also used for the expected forward probability.}
}
\value{
Data frame containing the profit-maximizing price, the resulting demand, profit, consumer surplus and 
economic welfare for the start WoM intensity and the expected WoM intensity.
}
\description{
Calculates the impact of incentivizing WoM communication. Given a start forward probability and an expected end forward, 
probability this function calculates changes in demand, consumer surplus, profit, cost for incentivizing and economic welfare
for i) keeping the optimal price for the start forward probability or ii) setting the optimized price for the expected 
forward probability.
}
\examples{

network <- new("WoMNetwork", size = 1000, avgConnections = 5)
campaign <- new("WoMCampaign", network = network, seedingSize = 10, forwardProbability = 0.2)
incentivization <- incentivizeWoM(campaign = campaign, expProb = 0.25, rewardCost = 0.05)
print(incentivization)

}
\seealso{
\code{\link{computeOptimalPrice}} \code{\link{computeProfit}} \code{\link{computeConsumerSurplus}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}

Thomas Woehner \email{Thomas.Woehner@eah-jena.de}

Ralf Peters \email{ralf.peters@wiwi.uni-halle.de}
}
