% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_stratified_analysis_sc.R
\name{categorize_sex_sc}
\alias{categorize_sex_sc}
\title{Compute sex-specific differentially expressed genes (DEGs) per category}
\usage{
categorize_sex_sc(
  male_degs,
  female_degs,
  target_fdr = 0.05,
  exclude_pval = 0.5,
  min_abs_logfc = 0.25
)
}
\arguments{
\item{male_degs}{Data frame containing male differential expression results from one specific cell-type or bulk dataset.}

\item{female_degs}{Data frame containing female differential expression results from one specific cell-type or bulk dataset.}

\item{target_fdr}{Numeric. FDR threshold for significance.}

\item{exclude_pval}{Numeric. P-value threshold for excluding genes in opposite sex.}

\item{min_abs_logfc}{Numeric. Minimum absolute log2 fold change threshold.}
}
\value{
Data frame containing categorized DEGs with associated statistics.
}
\description{
Identifies male-specific, female-specific, sex-dimorphic, and sex-neutral DEGs from differential expression results.
}
