% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_normalization.R
\name{ab_range_normalization}
\alias{ab_range_normalization}
\title{Normalization (or rescaling) between arbitrary a and b}
\usage{
ab_range_normalization(x, a, b)
}
\arguments{
\item{x}{numeric}

\item{a}{numeric}

\item{b}{numeric}
}
\value{
A numeric vector rescaled in the range \eqn{x' \in [a, b]}
}
\description{
Normalization (or rescaling) between arbitrary a and b
}
\examples{
x <- 5:100
a <- 0
b <- 1
x_scaled <- ab_range_normalization(x, a, b)
x_scaled
a <- 100
b <- 1000
x_scaled <- ab_range_normalization(x, a, b)
x_scaled
}
