% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{invade3}
\alias{invade3}
\title{Run Pairwise and Multiple Invasion Analysis}
\usage{
invade3(
  axis = NULL,
  mpm = NULL,
  vrm = NULL,
  stageframe = NULL,
  supplement = NULL,
  equivalence = NULL,
  starts = NULL,
  years = NULL,
  patches = NULL,
  tweights = NULL,
  format = NULL,
  entry_time = NULL,
  sp_density = NULL,
  ind_terms = NULL,
  dev_terms = NULL,
  fb_sparse = NULL,
  firstage = NULL,
  finalage = NULL,
  fecage_min = NULL,
  fecage_max = NULL,
  cont = NULL,
  prebreeding = NULL,
  fecmod = NULL,
  density = NULL,
  density_vr = NULL,
  stochastic = NULL,
  A_only = NULL,
  integeronly = NULL,
  fitness_table = NULL,
  trait_optima = NULL,
  zap_min = NULL,
  converged_only = NULL,
  err_check = NULL,
  var_per_run = 2L,
  substoch = 0L,
  elast_mult = 0.995,
  nreps = 1L,
  times = 10000L,
  fitness_times = 100L,
  exp_tol = 700,
  theta_tol = 1e+08,
  threshold = 1e-08,
  loop_max = 150L
)
}
\arguments{
\item{axis}{The \code{adaptAxis} object detailing all variant
characteristics. Essentially, a data frame giving the values of all changes
to vital rates and transition elements to test, where each value is change
is given by row.}

\item{mpm}{An MPM of class \code{lefkoMat}, for use if using existing MPMs.}

\item{vrm}{A \code{vrm_input} object corresponding to a distinct MPM that
will be created during analysis. Requires a stageframe, entered in argument
\code{stageframe}.}

\item{stageframe}{A stageframe defining stages and the life cycle for the
entered object in argument \code{vrms}. Must be of class \code{stageframe}.}

\item{supplement}{An optional data frame of class \code{lefkoSD} providing
supplemental data that should be incorporated into function-based MPMs. See
\code{\link[lefko3]{supplemental}()} for details. Use only with argument
\code{vrm}.}

\item{equivalence}{An optional object of class \code{adaptEq} giving the
degree to which individuals in each stage are equivalent to one another.
May also be a numeric vector, in which case the vector must have the same
number of elements as the number of rows in the associated MPM, with each
element giving the effect of an individual of that age, stage, age-stage, or
stage-pair, depending on whether the MPM is age-based, ahistorical
stage-based, age-by-stage, or historical stage-based, respectively. Numeric
entries used in these vectors can be thought of as Lotka-Volterra
interaction terms, such as are used in multiple species competition models.}

\item{starts}{An optional \code{lefkoSV} object, which is a data frame
providing the starting numbers of individuals of each stage. If not
provided, then all projections start with a single individual per stage.}

\item{years}{An optional term corresponding to a single integer vector of
time \code{t} values. If a vector shorter than \code{times} is supplied,
then this vector will be cycled. Defaults to a vector of all detected
years in argument \code{mpm} or argument \code{vrm}.}

\item{patches}{An optional single string giving a single pop-patch to be
used during invasion analysis. Defaults to the population-level set or the
first patch, depending on whether the former exists.}

\item{tweights}{An optional numeric vector or matrice denoting the
probabilities of choosing each matrix in each MPM in a stochastic
projection. If a matrix, then a first-order Markovian environment is
assumed, in which the probability of choosing a specific annual matrix
depends on which annual matrix is currently chosen. If an element of the
list is a vector, then the choice of annual matrix is assumed to be
independent of the current matrix. Defaults to equal weighting among
matrices.}

\item{format}{An optional integer indicating the kind of function-based MPM
to create, if argument \code{vrm} is provided. Possible choices include:
\code{1}, Ehrlen-format historical MPM; \code{2}, deVries-format historical
MPM; \code{3}, ahistorical MPM (default); \code{4}, age-by-stage MPM; and
\code{5}, Leslie (age-based) MPM. Defaults to \code{3}.}

\item{entry_time}{An optional integer vector giving the entry time for each
variant into each simulation. Defaults to a zero vector with length equal to
the number of variants to run concurrently in each simulation, as given by
argument \code{var_per_run}. Note that if two variants are to be run at a
time, as in a pairwise invasion analysis, then the length of the vector
should be equal to 2.}

\item{sp_density}{An optional argument for use with argument \code{vrm} that
specifies the spatial density to be used in each time step. If used, then
may either be a numeric vector giving a single spatial density for each
time step. If vectors are shorter than specified in \code{times}, then these
values will be cycled.}

\item{ind_terms}{An optional argument providing values of individual or
environmental covariate values for argument \code{vrm}. Should be set to a
single data frame with 3 columns giving values for up to 3 covariates across
time (rows give the time order of these values). Unused terms within the
data frame must be set to \code{0} (use of \code{NA} will produce errors).
If the number of rows is less than \code{times}, then these values will be
cycled.}

\item{dev_terms}{An optional  data frame including 14 columns and up to
\code{times} rows showing the values of the deviation terms to be added to
each linear vital rate. The column order should be: 1: survival,
2: observation, 3: primary size, 4: secondary size, 5: tertiary size,
6: reproduction, 7: fecundity, 8: juvenile survival, 9: juvenile
observation, 10: juvenile primary size, 11: juvenile secondary size,
12: juvenile tertiary size, 13: juvenile reproduction, and 14: juvenile
maturity transition. Unused terms must be set to \code{0} (use of \code{NA}
will produce errors). Single or small numbers of values per vital rate model
are also allowed, and if the number of rows is less than \code{times}, then
the terms will be cycled.}

\item{fb_sparse}{A logical value indicating whether function-based MPMs
should be produced in sparse matrix format. Defaults to \code{FALSE}.}

\item{firstage}{An optional integer used for function-based Leslie and
age-by-stage MPMs giving the starting age in such MPMs. Use only if the MPM
is both function-based and has age structure. Typically, the starting age in
such MPMs should be set to \code{0} if post-breeding and \code{1} if
pre-breeding. All other MPMs should be set to \code{0}.}

\item{finalage}{An optional integer used for function-based Leslie and
age-by-stage MPMs giving the final age in such MPMs. Use only if the MPM is
both function-based and has age structure.}

\item{fecage_min}{An optional integer used for function-based Leslie MPMs
giving the first age at which organisms can reproduce. Use only if the MPM
is both function-based and has age structure. Defaults to the value given in
\code{firstage}.}

\item{fecage_max}{An optional integer used for function-based Leslie MPMs
giving the final age at which organisms can reproduce. Use only if the MPM
is both function-based and has age structure. Defaults to the value given in
\code{finalage}.}

\item{cont}{An optional logical value for function-based Leslie and
age-by-stage MPMs stating whether the MPM should should include a stasis
transition within the final age. This should be used only when an organism
can maintain the demographic characteristics of the final described age
after reaching that age.}

\item{prebreeding}{An optional logical value indicating whether the life
cycle is prebreeding (\code{TRUE}) or postbreeding (\code{FALSE}). Defaults 
to \code{TRUE}.}

\item{fecmod}{An optional numeric value for function-based MPMs giving
scalar multipliers for fecundity terms, when two fecundity variables are
used for a collective fecundity per individual.}

\item{density}{An optional data frames of class \code{lefkoDens}, which
provides details for density dependence in MPM elements and is created with
function \code{\link[lefko3]{density_input}()}. Defaults to \code{NULL}, in
which case no density dependence is built into matrix elements.}

\item{density_vr}{An optional data frame of class \code{lefkoDensVR}, which
provides details for density dependence in vital rate models and has been
created with function \code{link[lefko3]{density_vr}()}. Can only be used
with function-based projections. Defaults to \code{NULL}, in which case no
density dependence is built into vital rates.}

\item{stochastic}{A logical value indicating whether the projection will be
run as a temporally stochastic projection. Defaults to \code{FALSE}.}

\item{A_only}{A logical value indicating whether to alter survival and
fecundity matrix elements separately prior to creating the overall \code{A}
matrix, or whether to alter elements directly on \code{A} matrices. Defaults
to \code{TRUE}, and should be kept to that setting unless some matrix
elements to be altered are sums of survival and fecundity transitions.}

\item{integeronly}{A logical value indicating whether to round the number of
individuals projected in each stage at each occasion down to the next lower
integer. Defaults to \code{FALSE}.}

\item{fitness_table}{A logical value dictating whether to include a data
frame giving Lyapunov coefficients for all combinations of variants tested.
Necessary for the creation of pairwise invasibility plots (PIPs). Defaults
to \code{TRUE}.}

\item{trait_optima}{A logical value indicating whether to assess the optimal
values of traits, generally as kinds of evolutionary stage equilibrium (ESS)
points. Trait optimization is conducted via elasticity analysis of traits
that are variable within the \code{trait_axis} table. Defaults to
\code{FALSE}.}

\item{zap_min}{A logical value indicating whether to treat traits and
fitness as 0 when their absolute values are less than the value given in
argument \code{threshold}.}

\item{converged_only}{A logical value indicating whether to show predicted
trait optima only in cases where the Lyapunov coefficient in elasticity
analysis has converged to 0. Defaults to \code{TRUE}.}

\item{err_check}{A logical value indicating whether to include an extra list
of output objects for error checking. Can also be set to the text value
\code{"extreme"}, in which case all \code{err_check} output plus a multiple
level list with each MPM used in each time step will be output.}

\item{var_per_run}{The number of variants to run in each simulation.
Defaults to \code{2}, resulting in pairwise invasibility analysis. See
\code{Notes} for details.}

\item{substoch}{An integer value indicating whether to force survival-
transition matrices to be substochastic in density dependent and density
independent simulations. Defaults to \code{0}, which does not enforce
substochasticity. Alternatively, \code{1} forces all survival-transition
elements to range from 0.0 to 1.0, and forces fecundity to be non-negative;
and \code{2} forces all column rows in the survival-transition matrices to
total no more than 1.0, in addition to the actions outlined for option
\code{1}. Both settings \code{1} and \code{2} change negative fecundity
elements to \code{0.0}, while setting \code{0} does not alter fecundity.}

\item{elast_mult}{A multiplier for traits to assess the elasticity of
fitness in trait optimization. Defaults to \code{0.995}.}

\item{nreps}{The number of replicate projections. Defaults to \code{1}.}

\item{times}{Number of occasions to iterate per replicate. Defaults to
\code{10000}.}

\item{fitness_times}{An integer giving the number of time steps at the end
of each run to use to estimate the fitness of the respective genotype.
Defaults to \code{100}, but if \code{times < 100}, then is set equal to
\code{times}.}

\item{exp_tol}{A numeric value used to indicate a maximum value to set
exponents to in the core kernel to prevent numerical overflow. Defaults to
\code{700}.}

\item{theta_tol}{A numeric value used to indicate a maximum value to theta as
used in the negative binomial probability density kernel. Defaults to
\code{100000000}, but can be reset to other values during error checking.}

\item{threshold}{The lower limit for the absolute value of fitness, below
which fitness is rounded to 0. Defaults to 0.00000001.}

\item{loop_max}{An integer value denoting the number of search cycles
allowed per ESS during ESS optimization. Defaults to 150.}
}
\value{
A list of class \code{adaptInv}, with the following elements:
\item{fitness}{A data frame giving the Lyapunov coefficients estimated for
each variant, per replicate.}
\item{variants_out}{A two-level list with the top level list having number of
elements equal to the number of variants, and the lower level
corresponding to the number of replicates. Each element of the lower level
list is a matrix showing the number of individuals in each stage (row) at each
time (column).}
\item{N_out}{A list with the number of elements equal to the number of
replicates. Each element within this list is data frame showing the number
of individuals of each species or genotype alive at each time. The number of
rows are equal to the number of MPMs used, and the columns correspond to the
time steps.}
\item{stageframe_list}{A list in which each element is the stageframe for
each MPM used.}
\item{hstages_list}{A list giving the used \code{hstages} data frames, which
identify the correct stage pairing for each row / column in each
historical MPM utilized.}
\item{agestages_list}{A list giving the used \code{agestages} data frames,
which identify the correct age-stage pairing for each row / column in each
age-by-stage MPM utilized.}
\item{labels}{A small data frame giving the the population and patch
identities for each MPM entered.}
\item{err_check}{An optional list composed of an additional six lists, each
of which has the number of elements equal to the number of MPMs utilized.
List output include \code{allstages_all}, which gives the indices of
estimated transitions in MPMs constructed by function \code{invade3()} from
input vital rate models; \code{allmodels_all}, which provides all vital rate
models as decomposed and interpreted by function \code{invade3()};
\code{equivalence_list}, which gives the stage equivalence for density
calculations across MPMs; \code{density_list}, which gives the
\code{density} inputs utilized; \code{dens_index_list}, which provides
indices used to identify matrix elements for density dependence; and
\code{density_vr_list}, which gives the \code{density_vr} inputs utilized.}
}
\description{
Function \code{invade3} runs pairwise and multiple invasion analyses.
}
\section{Notes}{

The argument \code{var_per_run} establishes the style of simulation to run.
Entering \code{var_per_run = 1} runs each variant singly. Entering
\code{var_per_run = 2} runs pairwise invasibility analysis, trying each pair
permutation of variants. Greater values will lead to multiple invasibility
analysis with different permutations of groups. For example,
\code{var_per_run = 3} runs each permutation of groups of three. The integer
set must be positive, and must not be larger than the number of variants.

When \code{optima = TRUE}, ESS values for traits that vary in the input
\code{adaptAxis} data frame are evaluated. The methodology is that
originally developed in Benton and Grant (1999, Evolution 53:677-688), as
communicated in Roff (2010, Modeling evolution: an introduction to numerical
methods, Oxford University Press). In essence, function \code{invade3}
determines which traits vary among all traits noted in the input trait axis.
A new trait axis is then created with values of variable traits multiplied
by 0.995, and this new trait axis is composed entirely of invaders that will
be paired against each respective row in the original trait axis. These two
trait axis frames are then used to conduct pairwise invasibility elasticity
analyses, particularly noting where fitness values and trends invert. Note
that this optimization approach really only works with one variable trait.
}

\examples{
library(lefko3)
data(cypdata)

sizevector <- c(0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "SL", "D", "XSm", "Sm", "Md", "Lg", "XLg")
repvector <- c(0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.40, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, 1000, 1000),
  type =c(1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")
cypmean <- lmean(cypmatrix2r)

cyp_start <- start_input(cypmean, stage2 = c("SD", "P1", "D"),
  value = c(1000, 200, 4))

c2d_4 <- density_input(cypmean, stage3 = c("P1", "P1"), stage2= c("SD", "rep"),
  style = 2, time_delay = 1, alpha = 0.005, beta = 0.000005, type = c(2, 2))

# A simple projection allows us to find a combination of density dependence
# and running time that produces a stable quasi-equilibrium
cyp_proj <- projection3(cypmean, times = 250, start_frame = cyp_start,
  density = c2d_4, integeronly = TRUE)
plot(cyp_proj)

cyp_ta <- trait_axis(stageframe = cypframe_raw,
  stage3 = rep("P1", 15),
  stage2 = rep("rep", 15),
  multiplier = seq(from = 0.1, to = 10.0, length.out = 15),
  type = rep(2, 15))

cyp_inv <- invade3(axis = cyp_ta, mpm = cypmean, density = c2d_4, times = 350,
  starts = cyp_start, entry_time = c(0, 250), fitness_times = 30,
  var_per_run = 2)
plot(cyp_inv)

}
