% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ta_skeleton}
\alias{ta_skeleton}
\title{Create Skeleton Data Frame for Trait Variation for Invasion Analysis}
\usage{
ta_skeleton(rows = 10L)
}
\arguments{
\item{rows}{The number of rows needed in the data frame. Defaults to 10.}
}
\value{
A data frame of class \code{adaptAxis}, with the following columns:
\item{variant}{Denotes each variant in order, with each row corresponding to
a novel variant.}
\item{stage3}{Stage at occasion \emph{t}+1 in the transition to be
replaced.}
\item{stage2}{Stage at occasion \emph{t} in the transition to be replaced.}
\item{stage1}{Stage at occasion \emph{t}-1 in the transition to be
replaced.}
\item{age3}{Age at occasion \emph{t}+1 in the transition to be replaced.}
\item{age2}{Age at occasion \emph{t} in the transition to be replaced.}
\item{eststage3}{Stage at occasion \emph{t}+1 in the transition to replace
the transition designated by \code{stage3}, \code{stage2}, and 
\code{stage1}.}
\item{eststage2}{Stage at occasion \emph{t} in the transition to replace the
transition designated by \code{stage3}, \code{stage2}, and \code{stage1}.}
\item{eststage1}{Stage at occasion \emph{t}-1 in the transition to replace
the transition designated by \code{stage3}, \code{stage2}, and 
\code{stage1}.}
\item{estage3}{Age at occasion \emph{t}+1 in the transition to replace the
transition designated by \code{age2}.}
\item{estage2}{Age at occasion \emph{t} in the transition to replace the
transition designated by \code{age2}.}
\item{givenrate}{A constant to be used as the value of the transition.}
\item{offset}{A constant value to be added to the transition or proxy
transition.}
\item{multiplier}{A multiplier for proxy transitions or for fecundity.}
\item{convtype}{Designates whether the transition from occasion \emph{t} to
occasion \emph{t}+1 is a survival transition probability (1), a fecundity
rate (2), or a fecundity multiplier (3).}
\item{convtype_t12}{Designates whether the transition from occasion
\emph{t}-1 to occasion \emph{t} is a survival transition probability (1), a
fecundity rate (2).}
\item{surv_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for survival probability.}
\item{obs_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for observation probability.}
\item{size_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for primary size transition.}
\item{sizeb_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for secondary size transition.}
\item{sizec_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for tertiary size transition.}
\item{repst_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for reproduction probability.}
\item{fec_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for fecundity.}
\item{jsurv_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for juvenile survival probability.}
\item{jobs_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for juvenile observation probability.}
\item{jsize_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for juvenile primary size transition.}
\item{jsizeb_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for juvenile secondary size transition.}
\item{jsizec_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for juvenile tertiary size transition.}
\item{jrepst_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for juvenile reproduction probability.}
\item{jmatst_dev}{A numeric vector giving the deviations to the y-intercept of
the vital rate model for maturity status.}
}
\description{
Function \code{ta_skeleton()} creates a core data frame that can be modified
by users to provide the core variation in transition elements and vital
rates to use in invasion analysis. The resulting data frame should be used
as input in function \code{\link{invade3}()}.
}
\examples{

current_traits <- ta_skeleton(4)
current_traits$stage3 <- c("Dorm", "Dorm", "Sdl1", NA)
current_traits$stage2 <- c("cut", "V0r", "rep", NA)
current_traits$convtype <- c(1, 1, 2, NA)
current_traits$offset <- c(0.1, 0.2, 0.3, NA)
current_traits$surv_dev <- c(NA, NA, NA, 0.1)

}
