% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicadores.R
\name{indicadores}
\alias{indicadores}
\title{Calcula indicadores financeiros a partir do Balanco Patrimonial e da Demonstracao do Resultado}
\usage{
indicadores(bp = NULL, dre = NULL)
}
\arguments{
\item{bp}{Um data.frame contendo o Balanco Patrimonial, com uma coluna Categoria e
colunas adicionais representando anos. As categorias devem seguir o padrao:
- ACO: Ativo Circulante Operacional
- ACF: Ativo Circulante Financeiro
- PCO: Passivo Circulante Operacional
- PCF: Passivo Circulante Financeiro
- ANC: Ativo Nao Circulante
- PNC: Passivo Nao Circulante
- PL: Patrimonio Liquido}

\item{dre}{Um data.frame contendo a Demonstracao do Resultado, tambem com coluna
Categoria e colunas representando anos. As principais categorias esperadas incluem:
- RECEITA_LIQUIDA
- CUSTO_BENS_SERVICOS
- DESPESAS_OPERACIONAIS
- RESULTADO_FINANCEIRO
- RESULTADO_LIQUIDO}
}
\value{
Uma lista contendo tres data.frames:
- indicadores_bp: Liquidez e estrutura de capital
- indicadores_dre: Margens operacionais
- indicadores_conjuntos: Indicadores integrados (inclui DuPont)
}
\description{
Esta funcao recebe dois data frames padronizados: um representando o Balanco Patrimonial
(bp) e outro representando a Demonstracao do Resultado (dre). A partir deles,
calcula indicadores classicos de liquidez, estrutura de capital, margens operacionais,
eficiencia e rentabilidade.
}
\details{
Caso a DRE contenha as categorias LUCRO_BRUTO, DESPESAS_OPERACIONAIS e
RESULTADO_FINANCEIRO, a funcao calcula automaticamente o EBIT, utilizado nos indicadores
de margem operacional e na razao EBIT/Ativo.

Indicadores calculados:

Balanco Patrimonial:
- Liquidez Corrente = (ACO + ACF) / (PCO + PCF)
- Liquidez Seca = ACO / (PCO + PCF)
- Liquidez Imediata = ACF / (PCO + PCF)
- Endividamento Geral = (PCO + PCF + PNC) / (ACO + ACF + ANC)
- Composicao do Endividamento = (PCO + PCF) / (PCO + PCF + PNC)
- Imobilizacao do PL = ANC / PL

Demonstracao do Resultado:
- Margem Bruta = (RECEITA_LIQUIDA - CUSTO_BENS_SERVICOS) / RECEITA_LIQUIDA
- Margem Operacional = EBIT / RECEITA_LIQUIDA
- Margem Liquida = RESULTADO_LIQUIDO / RECEITA_LIQUIDA

Indicadores Integrados (DuPont e rentabilidade):
- ROA = RESULTADO_LIQUIDO / Ativo Total
- ROE = RESULTADO_LIQUIDO / PL
- Giro do Ativo = RECEITA_LIQUIDA / Ativo Total
- Alavancagem Financeira = Ativo Total / PL
- EBIT/Ativo = EBIT / Ativo Total
}
\examples{
# Exemplo de dados padronizados para o Balanço Patrimonial
bp <- data.frame(
  Categoria = c("ACO", "ACF", "PCO", "PCF", "ANC", "PNC", "PL"),
  `2023` = c(50000, 20000, 30000, 10000, 80000, 40000, 90000),
  `2024` = c(54000, 22000, 32000, 12000, 82000, 45000, 92000),
  check.names = FALSE
)

# Exemplo de dados padronizados para a Demonstração do Resultado
dre <- data.frame(
  Categoria = c(
    "RECEITA_LIQUIDA",
    "CUSTO_BENS_SERVICOS",
    "DESPESAS_OPERACIONAIS",
    "RESULTADO_FINANCEIRO",
    "RESULTADO_LIQUIDO"
  ),
  `2023` = c(150000, 90000, 20000, -5000, 25000),
  `2024` = c(160000, 95000, 21000, -6000, 27000),
  check.names = FALSE
)

# Cálculo dos indicadores
resultado <- indicadores(bp, dre)

# Visualizando cada conjunto de resultados
resultado$indicadores_bp        # Liquidez, estrutura de capital
resultado$indicadores_dre       # Margens operacionais e líquidas
resultado$indicadores_conjuntos # ROA, ROE, DuPont etc.

}
