% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_joined.R
\name{get_joined_sub_data}
\alias{get_joined_sub_data}
\title{Join Data for "joined" functions}
\usage{
get_joined_sub_data(
  dataset,
  dataset_add,
  by_vars,
  tmp_obs_nr_var,
  tmp_obs_nr_left,
  join_type,
  first_cond_upper,
  first_cond_lower,
  filter_join
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{none}
}}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars}, the \code{new_vars}, the \code{join_vars},
and the \code{order} argument are expected.

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

The two datasets are joined by the specified variables.

Variables can be renamed by naming the element, i.e.
\verb{by_vars = exprs(<name in input dataset> = <name in additional dataset>)}, similar to the \code{dplyr} joins.

\describe{
\item{Permitted values}{list of variables created by \code{exprs()}, e.g., \code{exprs(USUBJID, VISIT)}}
\item{Default value}{\code{NULL}}
}}

\item{tmp_obs_nr_var}{Temporary observation number

The specified variable is added to the input dataset (\code{dataset}) and the
additional dataset (\code{dataset_add}). It is set to the observation number
with respect to \code{order}. For each by group (\code{by_vars}) the observation
number starts with \code{1}. The variable can be used in the conditions
(\code{filter_join}, \code{first_cond_upper}, \code{first_cond_lower}). It can also be
used to select consecutive observations or the last observation.

\describe{
\item{Permitted values}{an unquoted symbol, e.g., \code{AVAL}}
\item{Default value}{\code{NULL}}
}}

\item{tmp_obs_nr_left}{Temporary observation number for \code{dataset}

The specified variable has to be in the input dataset (\code{dataset}) and has to
be a unique key.

\describe{
\item{Default value}{none}
}}

\item{join_type}{Observations to keep after joining

The argument determines which of the joined observations are kept with
respect to the original observation. For example, if \code{join_type = "after"}
is specified all observations after the original observations are kept.

For example for confirmed response or BOR in the oncology setting or
confirmed deterioration in questionnaires the confirmatory assessment must
be after the assessment. Thus \code{join_type = "after"} could be used.

Whereas, sometimes you might allow for confirmatory observations to occur
prior to the observation. For example, to identify AEs occurring on or
after seven days before a COVID AE. Thus \code{join_type = "all"} could be used.

\describe{
\item{Permitted values}{\code{"before"}, \code{"after"}, \code{"all"}}
\item{Default value}{none}
}}

\item{first_cond_upper}{Condition for selecting range of data (after)

If this argument is specified, the other observations are restricted up to
the first observation where the specified condition is fulfilled. If the
condition is not fulfilled for any of the other observations, no
observations are considered, i.e., the observation is not flagged.

This argument should be specified if \code{filter_join} contains summary
functions which should not apply to all observations but only up to the
confirmation assessment.

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{\code{NULL}}
}}

\item{first_cond_lower}{Condition for selecting range of data (before)

If this argument is specified, the other observations are restricted from
the first observation before the current observation where the specified
condition is fulfilled up to the current observation. If the condition is
not fulfilled for any of the other observations, no observations are
considered, i.e., the observation is not flagged.

This argument should be specified if \code{filter_join} contains summary
functions which should not apply to all observations but only from a
certain observation before the current observation up to the current
observation.

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{\code{NULL}}
}}

\item{filter_join}{Filter for the joined dataset

The specified condition is applied to the joined dataset. Therefore
variables from both datasets \code{dataset} and \code{dataset_add} can be used.

Variables created by \code{order} or \code{new_vars} arguments can be used in the
condition.

The condition can include summary functions like \code{all()} or \code{any()}. The
joined dataset is grouped by the original observations.

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{\code{NULL}}
}}
}
\description{
The helper function joins the data for the "joined" functions. All \code{.join}
variables are included in the output dataset. It is called by
\code{get_joined_data()} to process each by group separately. This reduces the
memory consumption.
}
\details{
\enumerate{
\item The input dataset (\code{dataset}) and the additional dataset (\code{dataset_add})
are left joined by the grouping variables (\code{by_vars}). If no grouping
variables are specified, a full join is performed.
\item The joined dataset is restricted as specified by arguments \code{join_type},
\code{first_cond_upper}, and \code{first_cond_lower}. See argument descriptions for
details.
\item The joined dataset is restricted by the \code{filter_join} condition.
}
}
\keyword{internal}
