% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plot_vars_by_comp}
\alias{plot_vars_by_comp}
\title{Plot variable to component matrix of ADPROCLUS solution}
\usage{
plot_vars_by_comp(model, title = NULL, label_color = "black", ...)
}
\arguments{
\item{model}{Object of class \code{adpc}. Must be \strong{Low dimensional}
ADPROCLUS solution}

\item{title}{String. Optional title.}

\item{label_color}{String. The color of the text labels. Default: "black"}

\item{...}{Additional arguments passing to the
\code{corrplot::corrplot()} function, to customize the plot}
}
\value{
Invisibly returns the input model.
}
\description{
Produce a representation of variable to component matrix
\eqn{B'} of a \strong{low dimensional} ADPROCLUS solution
of class \code{adpc}. The plot displays the scores in the style of a
correlation plot.
\strong{NOTE:} This function can be called through the
\code{plot(model, type = "vars_by_comp")} function
with model an object of class \code{adpc}.
}
\examples{
# Loading a test dataset into the global environment
x <- stackloss

# Quick low dimensional clustering with K = 3 clusters and S = 1 dimensions
clust <- adproclus_low_dim(x, 3, 1)

# Plot the matrix B', connecting components with variables
plot_vars_by_comp(clust)
}
