#include <RcppArmadillo.h>
using namespace arma;
using namespace Rcpp;

// [[Rcpp::depends(RcppArmadillo)]]
//' @useDynLib afttest, .registration = TRUE
 //' @importFrom Rcpp evalCpp
 //' @exportPattern "^[[:alpha:]]+"
 
#ifdef RCPP_USE_GLOBAL_ROSTREAM
 Rcpp::Rostream<true>&  Rcpp::Rcout = Rcpp::Rcpp_cout_get();
 Rcpp::Rostream<false>& Rcpp::Rcerr = Rcpp::Rcpp_cerr_get();
#endif
 
 double target_score2_mis(vec b, vec time, vec delta, mat covariates, 
                          vec targetvector, int n, int p, double sqrtn){
   
   vec resid = log(time) + covariates*b;
   uvec index_resid = sort_index(resid);
   
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   mat tempmat_np = zeros(n,p); vec tempvec_n = zeros(n); vec F_vec = zeros(p);
   for(int it=0; it<n; it++){
     if (delta(it)==1){
       tempmat_np = covariates.row(it) - covariates.each_row();
       tempvec_n = sqrt(sum(tempmat_np%tempmat_np,1));
       tempvec_n.replace(0,1);
       
       tempvec_n = normcdf(sqrtn*(resid-resid(it))/tempvec_n);
       F_vec += sum(tempmat_np.each_col()%tempvec_n).t();
     }
   }
   F_vec = (F_vec - targetvector)/n;
   
   double F2norm = norm(F_vec);
   
   return F2norm;
 }
 
 double target_score2_mns(vec b, vec time, vec delta, mat covariates, 
                          vec targetvector, int n, int p){
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   mat tempmat_np = zeros(n,p); vec F_vec = zeros(p);
   for(int it=0; it<n; it++){
     if (delta(it)==1){
       tempmat_np = covariates.row(it) - covariates.each_row();
       F_vec += sum(tempmat_np.each_col()%conv_to<vec>::from((resid>=resid(it)))).t();
     }
   }
   F_vec = (F_vec - targetvector)/n;
   
   double F2norm = norm(F_vec);
   
   return F2norm;
 }
 
 vec target_score_mis(vec b, vec time, vec delta, mat covariates, 
                      vec targetvector, int n, int p, double sqrtn){
   
   vec resid = log(time) + covariates*b;
   uvec index_resid = sort_index(resid);
   
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   mat tempmat_np = zeros(n,p); vec tempvec_n = zeros(n); vec F_vec = zeros(p);
   for(int it=0; it<n; it++){
     if (delta(it)==1){
       tempmat_np = covariates.row(it) - covariates.each_row();
       tempvec_n = sqrt(sum(tempmat_np%tempmat_np,1));
       tempvec_n.replace(0,1);
       
       tempvec_n = normcdf(sqrtn*(resid-resid(it))/tempvec_n);
       F_vec += sum(tempmat_np.each_col()%tempvec_n).t();
     }
   }
   F_vec = (F_vec - targetvector)/n;
   
   return F_vec;
 }
 
 vec target_score_mns(vec b, vec time, vec delta, mat covariates, 
                      vec targetvector, int n, int p){
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   mat tempmat_np = zeros(n,p); vec F_vec = zeros(p);
   for(int it=0; it<n; it++){
     if (delta(it)==1){
       tempmat_np = covariates.row(it) - covariates.each_row();
       F_vec += sum(tempmat_np.each_col()%conv_to<vec>::from((resid>=resid(it)))).t();
     }
   }
   F_vec = (F_vec - targetvector)/n;
   
   return F_vec;
 }
 
 List dfsane_mis(vec b, vec time, vec delta, mat covariates, 
                 vec targetvector, int n, int p, double sqrtn){
   
   vec b_old = b;
   vec F_old = target_score_mis(b_old,time,delta,covariates,targetvector,n,p,sqrtn);
   double sig_k = (1/sqrt(dot(F_old, F_old))); if (sig_k>1){sig_k=1;}
   
   vec b_new = b_old - sig_k*F_old;
   
   vec F_new = target_score_mis(b_new,time,delta,covariates,targetvector,n,p,sqrtn);
   
   vec s_k = b_new - b_old;
   vec y_k = F_new - F_old;
   
   double tol_0 = dot(F_old, F_old);
   double tol_s = dot(s_k, s_k);
   double tol_y = dot(y_k, y_k);
   double tol_f = dot(F_new, F_new);
   
   // Stop sqrt(tol_f)/sqrt(n) <= e_a + e_r * sqrt(tol_0)/sqrt(n)
   // Stop tol_f <= (e_a * sqrt(n) + e_r * sqrt(tol_0))^{2}
   double e_a = 1e-5; double e_r = 1e-4;
   // double e_a = 1e-4; double e_r = 1e-3;
   double optim_tol = pow(e_a * sqrt(n) + e_r * sqrt(tol_0),2);
   
   double tolerance=tol_f+1; double tau_min=0.1; double tau_max=0.5; 
   double sig_min=0.1; double sig_max=0.5; double alp_p=1; double alp_m=1; double gam=1e-4; 
   double M=1; vec f_bar=zeros(M); double it=1; double maxit=500;
   double eta_k, abssig_k, RHS_p, LHS_p, RHS_m, LHS_m, alp_p_t, alp_m_t;
   vec b_new_p, F_new_p, b_new_m, F_new_m;
   while(tolerance>optim_tol){
     
     // STEP 1
     eta_k = tol_0/pow(1+it,2);
     
     if (tol_y>0) {
       sig_k = dot(s_k, y_k)/tol_y;
     } 
     
     abssig_k = std::abs(sig_k);
     if ((sig_min>abssig_k) || (sig_max<abssig_k)){
       if (tol_f<1e-10){
         sig_k = 1e+5;
       } else if (tol_f>1){
         sig_k = 1;
       } else {
         sig_k = 1/sqrt(tol_f);
       }
     }
     
     vec d_k = - sig_k * F_new;
     
     // STEP 2
     int step_tol = 0; int itt = it - M * floor(it/M); f_bar(itt) = tol_f; double a_k = 0;
     while(step_tol == 0){
       
       // alpha_plus
       b_new_p = b_new + alp_p * d_k;
       F_new_p = target_score_mis(b_new_p,time,delta,covariates,targetvector,n,p,sqrtn);
       
       RHS_p = dot(F_new_p, F_new_p);
       LHS_p = f_bar.max() + eta_k - gam * pow(alp_p,2) * tol_f;
       
       // alpha_minus
       b_new_m = b_new - alp_m * d_k;
       F_new_m = target_score_mis(b_new_m,time,delta,covariates,targetvector,n,p,sqrtn);
       
       RHS_m = dot(F_new_m, F_new_m);
       LHS_m = f_bar.max() + eta_k - gam * pow(alp_m,2) * tol_f;
       
       if (RHS_p<=LHS_p){
         // d_k = d_k;
         a_k = alp_p;
         b_new = b_old + a_k * d_k;
         step_tol = 1;
       } else if (RHS_m<=LHS_m){
         d_k = - d_k;
         a_k = alp_m;
         b_new = b_old + a_k * d_k;
         step_tol = 1;
       } else {
         
         alp_p_t = (pow(alp_p,2) * tol_f)/(RHS_p + (2 * alp_p - 1) * tol_f);
         
         if (alp_p_t>(tau_max*alp_p)){
           alp_p = tau_max * alp_p;
         } else if (alp_p_t<(tau_min*alp_p)){
           alp_p = tau_min * alp_p;
         } else {
           alp_p = alp_p_t;
         }
         
         alp_m_t = (pow(alp_m,2) * tol_f)/(RHS_m + (2 * alp_m - 1) * tol_f);
         
         if (alp_m_t>tau_max*alp_m){
           alp_m = tau_max * alp_m;
         } else if (alp_m_t<tau_min*alp_m){
           alp_m = tau_min * alp_m;
         } else {
           alp_m = alp_m_t;
         }
       }
     }
     
     // STEP 3
     F_new = target_score_mis(b_new,time,delta,covariates,targetvector,n,p,sqrtn);
     
     s_k = b_new - b_old;
     y_k = F_new - F_old;
     
     b_old = b_new;
     F_old = F_new;    
     
     tol_s = dot(s_k, s_k);
     tol_y = dot(y_k, y_k);
     tol_f = dot(F_new, F_new);
     
     tolerance = tol_f;
     if (tol_f>tol_s){tolerance = tol_s;}
     if (it>maxit){tolerance = 0;}
     it += 1;
   }
   
   return List::create(tol_f,b_new);
 }
 
 List dfsane_mns(vec b, vec time, vec delta, mat covariates, vec targetvector, int n, int p){
   
   vec b_old = b;
   vec F_old = target_score_mns(b_old,time,delta,covariates,targetvector,n,p);
   double sig_k = (1/sqrt(dot(F_old, F_old))); if (sig_k>1){sig_k=1;}
   
   vec b_new = b_old - sig_k*F_old;
   
   vec F_new = target_score_mns(b_new,time,delta,covariates,targetvector,n,p);
   
   vec s_k = b_new - b_old;
   vec y_k = F_new - F_old;
   
   double tol_0 = dot(F_old, F_old);
   double tol_s = dot(s_k, s_k);
   double tol_y = dot(y_k, y_k);
   double tol_f = dot(F_new, F_new);
   
   // Stop sqrt(tol_f)/sqrt(n) <= e_a + e_r * sqrt(tol_0)/sqrt(n)
   // Stop tol_f <= (e_a * sqrt(n) + e_r * tol_0)^{2}
   double e_a = 1e-5; double e_r = 1e-4;
   // double e_a = 1e-4; double e_r = 1e-3;
   double optim_tol = pow(e_a * sqrt(n) + e_r * sqrt(tol_0),2);
   
   double tolerance=tol_f+1; double tau_min=0.1; double tau_max=0.5; 
   double sig_min=0.1; double sig_max=0.5; double alp_p=1; double alp_m=1; double gam=1e-4; 
   double M=1; vec f_bar=zeros(M); double it=1; double maxit=500;
   double eta_k, abssig_k, RHS_p, LHS_p, RHS_m, LHS_m, alp_p_t, alp_m_t;
   vec b_new_p, F_new_p, b_new_m, F_new_m;
   while(tolerance>optim_tol){
     
     // STEP 1
     eta_k = tol_0/pow(1+it,2);
     
     if (tol_y>0) {
       sig_k = dot(s_k, y_k)/tol_y;
     } 
     
     abssig_k = std::abs(sig_k);
     if ((sig_min>abssig_k) || (sig_max<abssig_k)){
       if (tol_f<1e-10){
         sig_k = 1e+5;
       } else if (tol_f>1){
         sig_k = 1;
       } else {
         sig_k = 1/sqrt(tol_f);
       }
     }
     
     vec d_k = - sig_k * F_new;
     
     // STEP 2
     int step_tol = 0; int itt = it - M * floor(it/M); f_bar(itt) = tol_f; double a_k = 0;
     while(step_tol == 0){
       
       // alpha_plus
       b_new_p = b_new + alp_p * d_k;
       F_new_p = target_score_mns(b_new_p,time,delta,covariates,targetvector,n,p);
       
       RHS_p = dot(F_new_p, F_new_p);
       LHS_p = f_bar.max() + eta_k - gam * pow(alp_p,2) * tol_f;
       
       // alpha_minus
       b_new_m = b_new - alp_m * d_k;
       F_new_m = target_score_mns(b_new_m,time,delta,covariates,targetvector,n,p);
       
       RHS_m = dot(F_new_m, F_new_m);
       LHS_m = f_bar.max() + eta_k - gam * pow(alp_m,2) * tol_f;
       
       if (RHS_p<=LHS_p){
         // d_k = d_k;
         a_k = alp_p;
         b_new = b_old + a_k * d_k;
         step_tol = 1;
       } else if (RHS_m<=LHS_m){
         d_k = - d_k;
         a_k = alp_m;
         b_new = b_old + a_k * d_k;
         step_tol = 1;
       } else {
         
         alp_p_t = (pow(alp_p,2) * tol_f)/(RHS_p + (2 * alp_p - 1) * tol_f);
         
         if (alp_p_t>(tau_max*alp_p)){
           alp_p = tau_max * alp_p;
         } else if (alp_p_t<(tau_min*alp_p)){
           alp_p = tau_min * alp_p;
         } else {
           alp_p = alp_p_t;
         }
         
         alp_m_t = (pow(alp_m,2) * tol_f)/(RHS_m + (2 * alp_m - 1) * tol_f);
         
         if (alp_m_t>tau_max*alp_m){
           alp_m = tau_max * alp_m;
         } else if (alp_m_t<tau_min*alp_m){
           alp_m = tau_min * alp_m;
         } else {
           alp_m = alp_m_t;
         }
       }
     }
     
     // STEP 3
     F_new = target_score_mns(b_new,time,delta,covariates,targetvector,n,p);
     
     s_k = b_new - b_old;
     y_k = F_new - F_old;
     
     b_old = b_new;
     F_old = F_new;    
     
     tol_s = dot(s_k, s_k);
     tol_y = dot(y_k, y_k);
     tol_f = dot(F_new, F_new);
     
     tolerance = tol_f;
     if (tol_f>tol_s){tolerance = tol_s;}
     if (it>maxit){tolerance = 0;}
     it += 1;
   }
   
   return List::create(tol_f,b_new);
 }
 
 List omni_mis_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int npathsave){
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   mat sorted_Covari = sort(covariates);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (prod(covariates.row(it)<=sorted_Covari.row(itt))*1);
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; t by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); mat obs_npath = zero_mat_nn;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += tempvec_n*(as<rowvec>(pi_i_z(it)));
   }
   obs_npath /= sqrtn;
   // rowvec obs_npath_row0 = obs_npath.row(0);
   // obs_npath.each_row() -= obs_npath_row0;
   // obs_npath.each_col() -= obs_npath.col(0);
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_t_z(p);
   tempvec_n = fhat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
       }
     }
     fhat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       List b_s_result = dfsane_mis(b, time, delta, covariates, U_phi_inf, n, p, sqrtn);
       tolerance = as<double>(b_s_result[0]);
       b_s = as<vec>(b_s_result[1]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_t_z = cumsum(tempmat_nn);
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     mat term1 = U_pi_phi_t_z/sqrtn;
     mat term2 = zero_mat_nn;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<mat>(fhat_t_z(it))+cumsum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t))*(tempvec_p(it));
     }
     mat term3 = cumsum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))/sqrtn;
     
     tempmat_nn = term1 - term2 - term3;
     // tempmat_nn.each_row() -= obs_npath_row0;
     app_npath(itt) = tempmat_nn;
   }
   
   NumericMatrix tempmat_n2npath(pow(n,2),npath);
   for(int it=0; it<npath; it++){
     tempmat_n2npath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec mat_se_boot = stddev(as<mat>(tempmat_n2npath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_mat_se_boot = mat_se_boot(find(mat_se_boot > 0)).min();
   // mat_se_boot.replace(0, min_mat_se_boot); 
   // mat se_boot = reshape(mat_se_boot,n,n);
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {sqrt(censoring), 1};
   kappa = quantile(mat_se_boot, kappa);
   mat_se_boot.clamp(kappa(0),kappa(1));
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   mat se_boot = reshape(mat_se_boot,n,n);
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempmat_nn = as<mat>(app_npath(it));
     absmax_app_npath(it) = abs(tempmat_nn).max();
     
     tempmat_nn /= se_boot;
     app_std_npath(it) = tempmat_nn;
     absmax_app_std_npath(it) = abs(tempmat_nn).max();
   }
   
   mat obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List omni_mns_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int npathsave){
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   mat sorted_Covari = sort(covariates);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (prod(covariates.row(it)<=sorted_Covari.row(itt))*1);
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; t by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); mat obs_npath = zero_mat_nn;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += tempvec_n*(as<rowvec>(pi_i_z(it)));
   }
   obs_npath /= sqrtn;
   // rowvec obs_npath_row0 = obs_npath.row(0);
   // obs_npath.each_row() -= obs_npath_row0;
   // obs_npath.each_col() -= obs_npath.col(0);
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_t_z(p);
   tempvec_n = fhat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
       }
     }
     fhat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       List b_s_result = dfsane_mns(b, time, delta, covariates, U_phi_inf, n, p);
       tolerance = as<double>(b_s_result[0]);
       b_s = as<vec>(b_s_result[1]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_t_z = cumsum(tempmat_nn);
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     mat term1 = U_pi_phi_t_z/sqrtn;
     mat term2 = zero_mat_nn;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<mat>(fhat_t_z(it))+cumsum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t))*(tempvec_p(it));
     }
     mat term3 = cumsum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))/sqrtn;
     
     tempmat_nn = term1 - term2 - term3;
     // tempmat_nn.each_row() -= obs_npath_row0;
     app_npath(itt) = tempmat_nn;
   }
   
   NumericMatrix tempmat_n2npath(pow(n,2),npath);
   for(int it=0; it<npath; it++){
     tempmat_n2npath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec mat_se_boot = stddev(as<mat>(tempmat_n2npath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_mat_se_boot = mat_se_boot(find(mat_se_boot > 0)).min();
   // mat_se_boot.replace(0, min_mat_se_boot); 
   // mat se_boot = reshape(mat_se_boot,n,n);
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {sqrt(censoring), 1};
   kappa = quantile(mat_se_boot, kappa);
   mat_se_boot.clamp(kappa(0),kappa(1));
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   mat se_boot = reshape(mat_se_boot,n,n);
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempmat_nn = as<mat>(app_npath(it));
     absmax_app_npath(it) = abs(tempmat_nn).max();
     
     tempmat_nn /= se_boot;
     app_std_npath(it) = tempmat_nn;
     absmax_app_std_npath(it) = abs(tempmat_nn).max();
   }
   
   mat obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List link_mis_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int npathsave){
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   mat sorted_Covari = sort(covariates);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (prod(covariates.row(it)<=sorted_Covari.row(itt))*1);
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; 1 by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); vec obs_npath = zero_vec_n;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += (tempvec_n(n-1))*as<vec>(pi_i_z(it));
   }
   obs_npath /= sqrtn;
   // vec obs_npath_0 = obs_npath(0) * one_vec_n;
   // obs_npath -= obs_npath_0;
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_inf_z(p);
   double tempvec_1 = fhat_0_t(n-1) * time(n-1);
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempvec_n = zero_vec_n;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempvec_n += tempvec_1*(as<vec>(pi_i_z(it))*Covari_col(it));
       }
     }
     fhat_inf_z(itt) = tempvec_n/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       List b_s_result = dfsane_mis(b, time, delta, covariates, U_phi_inf, n, p, sqrtn);
       tolerance = as<double>(b_s_result[0]);
       b_s = as<vec>(b_s_result[1]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_inf_z = (sum(tempmat_nn)).t();
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     vec term1 = U_pi_phi_inf_z/sqrtn;
     vec term2 = zero_vec_n;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<vec>(fhat_inf_z(it))+(sum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t)).t())*(tempvec_p(it));
     }
     vec term3 = (sum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))).t()/sqrtn;
     
     tempvec_n = term1 - term2 - term3;
     // tempvec_n -= obs_npath_0;
     app_npath(itt) = tempvec_n;
   }
   
   NumericMatrix tempmat_nnpath(n,npath);
   for(int it=0; it<npath; it++){
     tempmat_nnpath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec se_boot = stddev(as<mat>(tempmat_nnpath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_se_boot = se_boot(find(se_boot > 0)).min();
   // se_boot.replace(0, min_se_boot); 
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {censoring, 1};
   kappa = quantile(se_boot, kappa);
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   se_boot.clamp(kappa(0),kappa(1));
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempvec_n = as<vec>(app_npath(it));
     absmax_app_npath(it) = abs(tempvec_n).max();
     
     tempvec_n /= se_boot;
     app_std_npath(it) = tempvec_n;
     absmax_app_std_npath(it) = abs(tempvec_n).max();
   }
   
   vec obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List link_mns_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int npathsave){
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   mat sorted_Covari = sort(covariates);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (prod(covariates.row(it)<=sorted_Covari.row(itt))*1);
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; 1 by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); vec obs_npath = zero_vec_n;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += (tempvec_n(n-1))*as<vec>(pi_i_z(it));
   }
   obs_npath /= sqrtn;
   // vec obs_npath_0 = obs_npath(0) * one_vec_n;
   // obs_npath -= obs_npath_0;
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_inf_z(p);
   double tempvec_1 = fhat_0_t(n-1) * time(n-1);
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempvec_n = zero_vec_n;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempvec_n += tempvec_1*(as<vec>(pi_i_z(it))*Covari_col(it));
       }
     }
     fhat_inf_z(itt) = tempvec_n/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       List b_s_result = dfsane_mns(b, time, delta, covariates, U_phi_inf, n, p);
       tolerance = as<double>(b_s_result[0]);
       b_s = as<vec>(b_s_result[1]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_inf_z = (sum(tempmat_nn)).t();
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     vec term1 = U_pi_phi_inf_z/sqrtn;
     vec term2 = zero_vec_n;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<vec>(fhat_inf_z(it))+(sum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t)).t())*(tempvec_p(it));
     }
     vec term3 = (sum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))).t()/sqrtn;
     
     tempvec_n = term1 - term2 - term3;
     // tempvec_n -= obs_npath_0;
     app_npath(itt) = tempvec_n;
   }
   
   NumericMatrix tempmat_nnpath(n,npath);
   for(int it=0; it<npath; it++){
     tempmat_nnpath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec se_boot = stddev(as<mat>(tempmat_nnpath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_se_boot = se_boot(find(se_boot > 0)).min();
   // se_boot.replace(0, min_se_boot); 
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {censoring, 1};
   kappa = quantile(se_boot, kappa);
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   se_boot.clamp(kappa(0),kappa(1));
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempvec_n = as<vec>(app_npath(it));
     absmax_app_npath(it) = abs(tempvec_n).max();
     
     tempvec_n /= se_boot;
     app_std_npath(it) = tempvec_n;
     absmax_app_std_npath(it) = abs(tempvec_n).max();
   }
   
   vec obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List form_mis_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int cov_tested, int npathsave){
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   vec form_Covari = covariates.col(cov_tested-1);
   vec sorted_form_Covari = sort(form_Covari);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (form_Covari(it)<=sorted_form_Covari(itt))*1;
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; 1 by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); vec obs_npath = zero_vec_n;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += (tempvec_n(n-1))*as<vec>(pi_i_z(it));
   }
   obs_npath /= sqrtn;
   // vec obs_npath_0 = obs_npath(0) * one_vec_n;
   // obs_npath -= obs_npath_0;
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_inf_z(p);
   double tempvec_1 = fhat_0_t(n-1) * time(n-1);
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempvec_n = zero_vec_n;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempvec_n += tempvec_1*(as<vec>(pi_i_z(it))*Covari_col(it));
       }
     }
     fhat_inf_z(itt) = tempvec_n/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       List b_s_result = dfsane_mis(b, time, delta, covariates, U_phi_inf, n, p, sqrtn);
       tolerance = as<double>(b_s_result[0]);
       b_s = as<vec>(b_s_result[1]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_inf_z = (sum(tempmat_nn)).t();
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     vec term1 = U_pi_phi_inf_z/sqrtn;
     vec term2 = zero_vec_n;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<vec>(fhat_inf_z(it))+(sum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t)).t())*(tempvec_p(it));
     }
     vec term3 = (sum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))).t()/sqrtn;
     
     tempvec_n = term1 - term2 - term3;
     // tempvec_n -= obs_npath_0;
     app_npath(itt) = tempvec_n;
   }
   
   NumericMatrix tempmat_nnpath(n,npath);
   for(int it=0; it<npath; it++){
     tempmat_nnpath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec se_boot = stddev(as<mat>(tempmat_nnpath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_se_boot = se_boot(find(se_boot > 0)).min();
   // se_boot.replace(0, min_se_boot); 
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {censoring, 1};
   kappa = quantile(se_boot, kappa);
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   se_boot.clamp(kappa(0),kappa(1));
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempvec_n = as<vec>(app_npath(it));
     absmax_app_npath(it) = abs(tempvec_n).max();
     
     tempvec_n /= se_boot;
     app_std_npath(it) = tempvec_n;
     absmax_app_std_npath(it) = abs(tempvec_n).max();
   }
   
   vec obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List form_mns_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int cov_tested, int npathsave){
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   vec form_Covari = covariates.col(cov_tested-1);
   vec sorted_form_Covari = sort(form_Covari);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (form_Covari(it)<=sorted_form_Covari(itt))*1;
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; 1 by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); vec obs_npath = zero_vec_n;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += (tempvec_n(n-1))*as<vec>(pi_i_z(it));
   }
   obs_npath /= sqrtn;
   // vec obs_npath_0 = obs_npath(0) * one_vec_n;
   // obs_npath -= obs_npath_0;
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_inf_z(p);
   double tempvec_1 = fhat_0_t(n-1) * time(n-1);
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempvec_n = zero_vec_n;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempvec_n += tempvec_1*(as<vec>(pi_i_z(it))*Covari_col(it));
       }
     }
     fhat_inf_z(itt) = tempvec_n/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       List b_s_result = dfsane_mns(b, time, delta, covariates, U_phi_inf, n, p);
       tolerance = as<double>(b_s_result[0]);
       b_s = as<vec>(b_s_result[1]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_inf_z = (sum(tempmat_nn)).t();
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     vec term1 = U_pi_phi_inf_z/sqrtn;
     vec term2 = zero_vec_n;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<vec>(fhat_inf_z(it))+(sum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t)).t())*(tempvec_p(it));
     }
     vec term3 = (sum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))).t()/sqrtn;
     
     tempvec_n = term1 - term2 - term3 - obs_npath(0) * one_vec_n;
     app_npath(itt) = tempvec_n;
   }
   
   NumericMatrix tempmat_nnpath(n,npath);
   for(int it=0; it<npath; it++){
     tempmat_nnpath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec se_boot = stddev(as<mat>(tempmat_nnpath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_se_boot = se_boot(find(se_boot > 0)).min();
   // se_boot.replace(0, min_se_boot); 
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {censoring, 1};
   kappa = quantile(se_boot, kappa);
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   se_boot.clamp(kappa(0),kappa(1));
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempvec_n = as<vec>(app_npath(it));
     absmax_app_npath(it) = abs(tempvec_n).max();
     
     tempvec_n /= se_boot;
     app_std_npath(it) = tempvec_n;
     absmax_app_std_npath(it) = abs(tempvec_n).max();
   }
   
   vec obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List omni_mis_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int npathsave){
   
   Rcpp::Environment stats("package:stats"); 
   Rcpp::Function optim = stats["optim"];
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   mat sorted_Covari = sort(covariates);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (prod(covariates.row(it)<=sorted_Covari.row(itt))*1);
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; t by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); mat obs_npath = zero_mat_nn;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += tempvec_n*(as<rowvec>(pi_i_z(it)));
   }
   obs_npath /= sqrtn;
   // rowvec obs_npath_row0 = obs_npath.row(0);
   // obs_npath.each_row() -= obs_npath_row0;
   // obs_npath.each_col() -= obs_npath.col(0);
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_t_z(p);
   tempvec_n = fhat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
       }
     }
     fhat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       Rcpp::List b_s_opt_results = optim(Rcpp::_["par"]    = b,
                                          Rcpp::_["fn"]     = Rcpp::InternalFunction(&target_score2_mis),
                                          Rcpp::_["method"] = optimType,
                                          Rcpp::_["time"] = time,
                                          Rcpp::_["delta"] = delta,
                                          Rcpp::_["covariates"] = covariates,
                                          Rcpp::_["targetvector"] = U_phi_inf,
                                          Rcpp::_["n"] = n,
                                          Rcpp::_["p"] = p,
                                          Rcpp::_["sqrtn"] = sqrtn);
       tolerance = as<double>(b_s_opt_results[1]);
       vec b_s = as<vec>(b_s_opt_results[0]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_t_z = cumsum(tempmat_nn);
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     mat term1 = U_pi_phi_t_z/sqrtn;
     mat term2 = zero_mat_nn;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<mat>(fhat_t_z(it))+cumsum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t))*(tempvec_p(it));
     }
     mat term3 = cumsum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))/sqrtn;
     
     tempmat_nn = term1 - term2 - term3;
     // tempmat_nn.each_row() -= obs_npath_row0;
     app_npath(itt) = tempmat_nn;
   }
   
   NumericMatrix tempmat_n2npath(pow(n,2),npath);
   for(int it=0; it<npath; it++){
     tempmat_n2npath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec mat_se_boot = stddev(as<mat>(tempmat_n2npath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_mat_se_boot = mat_se_boot(find(mat_se_boot > 0)).min();
   // mat_se_boot.replace(0, min_mat_se_boot); 
   // mat se_boot = reshape(mat_se_boot,n,n);
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {sqrt(censoring), 1};
   kappa = quantile(mat_se_boot, kappa);
   mat_se_boot.clamp(kappa(0),kappa(1));
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   mat se_boot = reshape(mat_se_boot,n,n);
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempmat_nn = as<mat>(app_npath(it));
     absmax_app_npath(it) = abs(tempmat_nn).max();
     
     tempmat_nn /= se_boot;
     app_std_npath(it) = tempmat_nn;
     absmax_app_std_npath(it) = abs(tempmat_nn).max();
   }
   
   mat obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List omni_mns_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int npathsave){
   
   Rcpp::Environment stats("package:stats"); 
   Rcpp::Function optim = stats["optim"];
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   mat sorted_Covari = sort(covariates);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (prod(covariates.row(it)<=sorted_Covari.row(itt))*1);
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; t by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); mat obs_npath = zero_mat_nn;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += tempvec_n*(as<rowvec>(pi_i_z(it)));
   }
   obs_npath /= sqrtn;
   // rowvec obs_npath_row0 = obs_npath.row(0);
   // obs_npath.each_row() -= obs_npath_row0;
   // obs_npath.each_col() -= obs_npath.col(0);
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_t_z(p);
   tempvec_n = fhat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
       }
     }
     fhat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       Rcpp::List b_s_opt_results = optim(Rcpp::_["par"]    = b,
                                          Rcpp::_["fn"]     = Rcpp::InternalFunction(&target_score2_mns),
                                          Rcpp::_["method"] = optimType,
                                          Rcpp::_["time"] = time,
                                          Rcpp::_["delta"] = delta,
                                          Rcpp::_["covariates"] = covariates,
                                          Rcpp::_["targetvector"] = U_phi_inf,
                                          Rcpp::_["n"] = n,
                                          Rcpp::_["p"] = p);
       tolerance = as<double>(b_s_opt_results[1]);
       vec b_s = as<vec>(b_s_opt_results[0]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_t_z = cumsum(tempmat_nn);
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     mat term1 = U_pi_phi_t_z/sqrtn;
     mat term2 = zero_mat_nn;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<mat>(fhat_t_z(it))+cumsum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t))*(tempvec_p(it));
     }
     mat term3 = cumsum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))/sqrtn;
     
     tempmat_nn = term1 - term2 - term3;
     // tempmat_nn.each_row() -= obs_npath_row0;
     app_npath(itt) = tempmat_nn;
   }
   
   NumericMatrix tempmat_n2npath(pow(n,2),npath);
   for(int it=0; it<npath; it++){
     tempmat_n2npath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec mat_se_boot = stddev(as<mat>(tempmat_n2npath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_mat_se_boot = mat_se_boot(find(mat_se_boot > 0)).min();
   // mat_se_boot.replace(0, min_mat_se_boot); 
   // mat se_boot = reshape(mat_se_boot,n,n);
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {sqrt(censoring), 1};
   kappa = quantile(mat_se_boot, kappa);
   mat_se_boot.clamp(kappa(0),kappa(1));
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   mat se_boot = reshape(mat_se_boot,n,n);
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempmat_nn = as<mat>(app_npath(it));
     absmax_app_npath(it) = abs(tempmat_nn).max();
     
     tempmat_nn /= se_boot;
     app_std_npath(it) = tempmat_nn;
     absmax_app_std_npath(it) = abs(tempmat_nn).max();
   }
   
   mat obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List link_mis_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int npathsave){
   
   Rcpp::Environment stats("package:stats"); 
   Rcpp::Function optim = stats["optim"];
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   mat sorted_Covari = sort(covariates);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (prod(covariates.row(it)<=sorted_Covari.row(itt))*1);
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; 1 by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); vec obs_npath = zero_vec_n;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += (tempvec_n(n-1))*as<vec>(pi_i_z(it));
   }
   obs_npath /= sqrtn;
   // vec obs_npath_0 = obs_npath(0) * one_vec_n;
   // obs_npath -= obs_npath_0;
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_inf_z(p);
   double tempvec_1 = fhat_0_t(n-1) * time(n-1);
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempvec_n = zero_vec_n;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempvec_n += tempvec_1*(as<vec>(pi_i_z(it))*Covari_col(it));
       }
     }
     fhat_inf_z(itt) = tempvec_n/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       Rcpp::List b_s_opt_results = optim(Rcpp::_["par"]    = b,
                                          Rcpp::_["fn"]     = Rcpp::InternalFunction(&target_score2_mis),
                                          Rcpp::_["method"] = optimType,
                                          Rcpp::_["time"] = time,
                                          Rcpp::_["delta"] = delta,
                                          Rcpp::_["covariates"] = covariates,
                                          Rcpp::_["targetvector"] = U_phi_inf,
                                          Rcpp::_["n"] = n,
                                          Rcpp::_["p"] = p,
                                          Rcpp::_["sqrtn"] = sqrtn);
       tolerance = as<double>(b_s_opt_results[1]);
       vec b_s = as<vec>(b_s_opt_results[0]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_inf_z = (sum(tempmat_nn)).t();
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     vec term1 = U_pi_phi_inf_z/sqrtn;
     vec term2 = zero_vec_n;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<vec>(fhat_inf_z(it))+(sum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t)).t())*(tempvec_p(it));
     }
     vec term3 = (sum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))).t()/sqrtn;
     
     tempvec_n = term1 - term2 - term3;
     // tempvec_n -= obs_npath_0;
     app_npath(itt) = tempvec_n;
   }
   
   NumericMatrix tempmat_nnpath(n,npath);
   for(int it=0; it<npath; it++){
     tempmat_nnpath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec se_boot = stddev(as<mat>(tempmat_nnpath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {censoring, 1};
   kappa = quantile(se_boot, kappa);
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   se_boot.clamp(kappa(0),kappa(1));
   
   // double min_se_boot = se_boot(find(se_boot > 0)).min();
   // se_boot.replace(0, min_se_boot); 
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempvec_n = as<vec>(app_npath(it));
     absmax_app_npath(it) = abs(tempvec_n).max();
     
     tempvec_n /= se_boot;
     app_std_npath(it) = tempvec_n;
     absmax_app_std_npath(it) = abs(tempvec_n).max();
   }
   
   vec obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List link_mns_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int npathsave){
   
   Rcpp::Environment stats("package:stats"); 
   Rcpp::Function optim = stats["optim"];
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   mat sorted_Covari = sort(covariates);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (prod(covariates.row(it)<=sorted_Covari.row(itt))*1);
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; 1 by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); vec obs_npath = zero_vec_n;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += (tempvec_n(n-1))*as<vec>(pi_i_z(it));
   }
   obs_npath /= sqrtn;
   // vec obs_npath_0 = obs_npath(0) * one_vec_n;
   // obs_npath -= obs_npath_0;
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_inf_z(p);
   double tempvec_1 = fhat_0_t(n-1) * time(n-1);
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempvec_n = zero_vec_n;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempvec_n += tempvec_1*(as<vec>(pi_i_z(it))*Covari_col(it));
       }
     }
     fhat_inf_z(itt) = tempvec_n/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       Rcpp::List b_s_opt_results = optim(Rcpp::_["par"]    = b,
                                          Rcpp::_["fn"]     = Rcpp::InternalFunction(&target_score2_mns),
                                          Rcpp::_["method"] = optimType,
                                          Rcpp::_["time"] = time,
                                          Rcpp::_["delta"] = delta,
                                          Rcpp::_["covariates"] = covariates,
                                          Rcpp::_["targetvector"] = U_phi_inf,
                                          Rcpp::_["n"] = n,
                                          Rcpp::_["p"] = p);
       tolerance = as<double>(b_s_opt_results[1]);
       vec b_s = as<vec>(b_s_opt_results[0]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_inf_z = (sum(tempmat_nn)).t();
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     vec term1 = U_pi_phi_inf_z/sqrtn;
     vec term2 = zero_vec_n;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<vec>(fhat_inf_z(it))+(sum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t)).t())*(tempvec_p(it));
     }
     vec term3 = (sum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))).t()/sqrtn;
     
     tempvec_n = term1 - term2 - term3;
     // tempvec_n -= obs_npath_0;
     app_npath(itt) = tempvec_n;
   }
   
   NumericMatrix tempmat_nnpath(n,npath);
   for(int it=0; it<npath; it++){
     tempmat_nnpath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec se_boot = stddev(as<mat>(tempmat_nnpath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_se_boot = se_boot(find(se_boot > 0)).min();
   // se_boot.replace(0, min_se_boot); 
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {censoring, 1};
   kappa = quantile(se_boot, kappa);
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   se_boot.clamp(kappa(0),kappa(1));
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempvec_n = as<vec>(app_npath(it));
     absmax_app_npath(it) = abs(tempvec_n).max();
     
     tempvec_n /= se_boot;
     app_std_npath(it) = tempvec_n;
     absmax_app_std_npath(it) = abs(tempvec_n).max();
   }
   
   vec obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List form_mis_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int cov_tested, int npathsave){
   
   Rcpp::Environment stats("package:stats"); 
   Rcpp::Function optim = stats["optim"];
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   vec form_Covari = covariates.col(cov_tested-1);
   vec sorted_form_Covari = sort(form_Covari);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (form_Covari(it)<=sorted_form_Covari(itt))*1;
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; 1 by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); vec obs_npath = zero_vec_n;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += (tempvec_n(n-1))*as<vec>(pi_i_z(it));
   }
   obs_npath /= sqrtn;
   // vec obs_npath_0 = obs_npath(0) * one_vec_n;
   // obs_npath -= obs_npath_0;
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_inf_z(p);
   double tempvec_1 = fhat_0_t(n-1) * time(n-1);
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempvec_n = zero_vec_n;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempvec_n += tempvec_1*(as<vec>(pi_i_z(it))*Covari_col(it));
       }
     }
     fhat_inf_z(itt) = tempvec_n/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       Rcpp::List b_s_opt_results = optim(Rcpp::_["par"]    = b,
                                          Rcpp::_["fn"]     = Rcpp::InternalFunction(&target_score2_mis),
                                          Rcpp::_["method"] = optimType,
                                          Rcpp::_["time"] = time,
                                          Rcpp::_["delta"] = delta,
                                          Rcpp::_["covariates"] = covariates,
                                          Rcpp::_["targetvector"] = U_phi_inf,
                                          Rcpp::_["n"] = n,
                                          Rcpp::_["p"] = p,
                                          Rcpp::_["sqrtn"] = sqrtn);
       tolerance = as<double>(b_s_opt_results[1]);
       vec b_s = as<vec>(b_s_opt_results[0]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_inf_z = (sum(tempmat_nn)).t();
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     vec term1 = U_pi_phi_inf_z/sqrtn;
     vec term2 = zero_vec_n;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<vec>(fhat_inf_z(it))+(sum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t)).t())*(tempvec_p(it));
     }
     vec term3 = (sum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))).t()/sqrtn;
     
     tempvec_n = term1 - term2 - term3;
     // tempvec_n -= obs_npath_0;
     app_npath(itt) = tempvec_n;
   }
   
   NumericMatrix tempmat_nnpath(n,npath);
   for(int it=0; it<npath; it++){
     tempmat_nnpath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec se_boot = stddev(as<mat>(tempmat_nnpath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_se_boot = se_boot(find(se_boot > 0)).min();
   // se_boot.replace(0, min_se_boot); 
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {censoring, 1};
   kappa = quantile(se_boot, kappa);
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   se_boot.clamp(kappa(0),kappa(1));
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempvec_n = as<vec>(app_npath(it));
     absmax_app_npath(it) = abs(tempvec_n).max();
     
     tempvec_n /= se_boot;
     app_std_npath(it) = tempvec_n;
     absmax_app_std_npath(it) = abs(tempvec_n).max();
   }
   
   vec obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 List form_mns_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int cov_tested, int npathsave){
   
   Rcpp::Environment stats("package:stats"); 
   Rcpp::Function optim = stats["optim"];
   
   int n = covariates.n_rows;
   int p = covariates.n_cols;
   
   double sqrtn = sqrt(n);
   
   vec zero_vec_1 = zeros(1);
   vec zero_vec_p = zeros(p);
   vec zero_vec_n = zeros(n);
   mat zero_mat_np = zeros(n,p);
   mat zero_mat_nn = zeros(n,n);
   
   vec one_vec_n = ones(n);
   
   vec tempvec_p(p);
   vec tempvec_n(n);
   mat tempmat_np(n,p);
   mat tempmat_nn(n,n);
   
   vec resid = log(time) + covariates*b;
   
   uvec index_resid = sort_index(resid);
   
   time = time(index_resid);
   delta = delta(index_resid);
   covariates = covariates.rows(index_resid);
   resid = resid(index_resid);
   
   List pi_i_z(n); List N_i_t(n); List Y_i_t(n);
   vec S_0_t = zero_vec_n; mat S_1_t = zero_mat_np; mat S_pi_t_z = zero_mat_nn;
   vec form_Covari = covariates.col(cov_tested-1);
   vec sorted_form_Covari = sort(form_Covari);
   tempvec_n = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       tempvec_n(itt) = (form_Covari(it)<=sorted_form_Covari(itt))*1;
     }
     pi_i_z(it) = tempvec_n;
     if (delta(it)==1){
       N_i_t(it) = (resid>=resid(it));
     } else {
       N_i_t(it) = zero_vec_n;
     }
     Y_i_t(it) = (resid<=resid(it))*1;
     S_0_t += as<vec>(Y_i_t(it));
     S_1_t += as<vec>(Y_i_t(it))*(covariates.row(it));
     S_pi_t_z += (as<vec>(Y_i_t(it)))*(as<rowvec>(pi_i_z(it)));
   }
   
   vec dLambdahat_0_t = delta/S_0_t;
   dLambdahat_0_t.replace(datum::nan,0);
   
   mat E_pi_t_z = S_pi_t_z.each_col()/S_0_t;
   E_pi_t_z.replace(datum::nan,0);
   
   // obs_npath; 1 by x vector
   List Mhat_i_t(n); List dMhat_i_t(n); vec obs_npath = zero_vec_n;
   for(int it=0; it<n; it++){
     tempvec_n = as<vec>(N_i_t(it))-(cumsum(as<vec>(Y_i_t(it))%(dLambdahat_0_t)));
     Mhat_i_t(it) = tempvec_n;
     dMhat_i_t(it) = diff(join_cols(zero_vec_1,tempvec_n));
     obs_npath += (tempvec_n(n-1))*as<vec>(pi_i_z(it));
   }
   obs_npath /= sqrtn;
   // vec obs_npath_0 = obs_npath(0) * one_vec_n;
   // obs_npath -= obs_npath_0;
   
   // -----------------------------------------------------------
   // ----------------------Kernel Smoothing---------------------
   // -----------------------------------------------------------
   double bw_base = pow((n*3/4),-0.2);
   vec pred_data = exp(resid);
   
   // -----------------------------g0----------------------------
   // vec given_data_g = exp(resid);
   vec given_data_g = pred_data;
   double bw_gn = bw_base * stddev(given_data_g);
   vec ghat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       ghat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn);
     }
   }
   ghat_0_t /= n;
   
   List ghat_t_z(p);
   tempvec_n = ghat_0_t % time;
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += tempvec_n*((as<rowvec>(pi_i_z(it)))*Covari_col(it));
     }
     ghat_t_z(itt) = tempmat_nn/n;
   }
   
   // -----------------------------f0----------------------------
   vec Shat_0_e = cumprod(one_vec_n - dLambdahat_0_t);
   vec Fhat_0_e = one_vec_n - Shat_0_e;
   vec dFhat_0_e = diff(join_cols(zero_vec_1,Fhat_0_e));
   
   vec fhat_0_t = zero_vec_n;
   for(int it=0; it<n; it++){
     for(int itt=0; itt<n; itt++){
       fhat_0_t(it) += normpdf(pred_data(it),given_data_g(itt),bw_gn) * dFhat_0_e(itt);
     }
   }
   
   // vec Condi_Ehat = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   Condi_Ehat(it) = sum(resid.tail(n-it-1)%dFhat_0_e.tail(n-it-1))/Shat_0_e(it);
   // }
   // Condi_Ehat.replace(datum::nan,0);
   // 
   // vec rhat_i = delta % resid + (one_vec_n - delta) % Condi_Ehat;
   // vec given_data_f = exp(rhat_i);
   // double bw_fn = bw_base * stddev(given_data_f);
   // vec fhat_0_t = zero_vec_n;
   // for(int it=0; it<n; it++){
   //   for(int itt=0; itt<n; itt++){
   //     fhat_0_t(it) += normpdf(pred_data(it),given_data_f(itt),bw_fn);
   //   }
   // }
   // fhat_0_t /= n;
   
   List fhat_inf_z(p);
   double tempvec_1 = fhat_0_t(n-1) * time(n-1);
   for(int itt=0; itt<p; itt++){
     vec Covari_col = covariates.col(itt);
     tempvec_n = zero_vec_n;
     for(int it=0; it<n; it++){
       if (delta(it)==1){
         tempvec_n += tempvec_1*(as<vec>(pi_i_z(it))*Covari_col(it));
       }
     }
     fhat_inf_z(itt) = tempvec_n/n;
   }
   
   // -----------------------------------------------------------
   // ------------------------Sample Path------------------------
   // -----------------------------------------------------------
   List app_npath(npath);
   for(int itt=0; itt<npath; itt++){
     
     vec phi_i(n); vec b_s(p); double tol = pow(p,2); double tolerance = tol+1;
     while(tolerance>tol){
       phi_i = randg(n) - one_vec_n; // randn(n);
       
       tempvec_n = zero_vec_n; tempmat_np = zero_mat_np;
       for(int it=0; it<n; it++){
         tempvec_n += as<vec>(dMhat_i_t(it))*phi_i(it);
         tempmat_np += (as<vec>(dMhat_i_t(it))*(covariates.row(it)))*phi_i(it);
       }
       vec U_phi_inf = sum((S_0_t%tempmat_np.each_col())-(S_1_t.each_col()%tempvec_n)).t();
       
       Rcpp::List b_s_opt_results = optim(Rcpp::_["par"]    = b,
                                          Rcpp::_["fn"]     = Rcpp::InternalFunction(&target_score2_mns),
                                          Rcpp::_["method"] = optimType,
                                          Rcpp::_["time"] = time,
                                          Rcpp::_["delta"] = delta,
                                          Rcpp::_["covariates"] = covariates,
                                          Rcpp::_["targetvector"] = U_phi_inf,
                                          Rcpp::_["n"] = n,
                                          Rcpp::_["p"] = p);
       tolerance = as<double>(b_s_opt_results[1]);
       vec b_s = as<vec>(b_s_opt_results[0]);
     }
     
     tempmat_nn = zero_mat_nn;
     for(int it=0; it<n; it++){
       tempmat_nn += ((as<vec>(dMhat_i_t(it)))*phi_i(it))%(as<rowvec>(pi_i_z(it))-E_pi_t_z.each_row()).each_col();
     }
     mat U_pi_phi_inf_z = (sum(tempmat_nn)).t();
     
     vec resid_s = log(time) + covariates*b_s;
     uvec index_resid_s = sort_index(resid_s);
     
     vec Delta_s = delta(index_resid_s);
     resid_s = resid_s(index_resid_s);
     
     NumericVector Y_i_t_s(n); vec S_0_t_s = zero_vec_n;
     for(int it=0; it<n; it++){
       Y_i_t_s = (resid_s<=resid_s(it))*1;
       S_0_t_s += as<vec>(Y_i_t_s);
     }
     
     vec dLambdahat_0_t_s = Delta_s/S_0_t_s;
     dLambdahat_0_t_s.replace(datum::nan,0);
     
     vec term1 = U_pi_phi_inf_z/sqrtn;
     vec term2 = zero_vec_n;
     tempvec_p = (b-b_s)*sqrtn;
     for(int it=0; it<p; it++){
       term2 += (as<vec>(fhat_inf_z(it))+(sum((as<mat>(ghat_t_z(it)).each_col())%dLambdahat_0_t)).t())*(tempvec_p(it));
     }
     vec term3 = (sum((S_pi_t_z.each_col())%(dLambdahat_0_t - dLambdahat_0_t_s))).t()/sqrtn;
     
     tempvec_n = term1 - term2 - term3;
     // tempvec_n -= obs_npath_0;
     app_npath(itt) = tempvec_n;
   }
   
   NumericMatrix tempmat_nnpath(n,npath);
   for(int it=0; it<npath; it++){
     tempmat_nnpath(_,it) = (as<NumericVector>(app_npath(it)));
   }
   vec se_boot = stddev(as<mat>(tempmat_nnpath),0,1);
   // too low values which are 0 or computationally 0 of se_boot makes a problem,
   // so we adjust them to have kappa = quantile of mat_se_boot
   // e.g., kappa_min = censoring; quantile(mat_se_boot) = {censoring, 1};
   // double censoring = 1-sum(delta)/n;
   // double kappa_min = censoring;
   // double kappa_max = 1;
   // if (kappa_min<0.1){kappa_min = 0.1;}
   // vec kappa = {kappa_min, kappa_max};
   
   // double min_se_boot = se_boot(find(se_boot > 0)).min();
   // se_boot.replace(0, min_se_boot); 
   
   double censoring = 1-sum(delta)/n;
   vec kappa = {censoring, 1};
   kappa = quantile(se_boot, kappa);
   // if (kappa(0)<0.1){kappa(0) = 0.1;}
   se_boot.clamp(kappa(0),kappa(1));
   
   List app_std_npath(npath); vec absmax_app_npath(npath); vec absmax_app_std_npath(npath);
   for(int it=0; it<npath; it++){
     tempvec_n = as<vec>(app_npath(it));
     absmax_app_npath(it) = abs(tempvec_n).max();
     
     tempvec_n /= se_boot;
     app_std_npath(it) = tempvec_n;
     absmax_app_std_npath(it) = abs(tempvec_n).max();
   }
   
   vec obs_std_npath = obs_npath/se_boot;
   double absmax_obs_npath = (abs(obs_npath)).max();
   double absmax_obs_std_npath = (abs(obs_std_npath)).max();
   
   uvec ind_unstd = (find(absmax_app_npath>absmax_obs_npath));
   double p_value = (ind_unstd.size()); p_value = p_value/npath;
   
   uvec ind_std = (find(absmax_app_std_npath>absmax_obs_std_npath));
   double p_std_value = (ind_std.size()); p_std_value = p_std_value/npath;
   
   if (npathsave<1){
     return List::create(_["p_std_value"]=p_std_value,_["p_value"]=p_value);
   } else if (npathsave > npath) {
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   } else {
     npathsave = npathsave - 1;
     app_npath = app_npath[Range(0,npathsave)];
     app_std_npath = app_std_npath[Range(0,npathsave)];
     return List::create(_["SE_boot"]=se_boot,
                         _["obs_npath"]=obs_npath,_["obs_std_npath"]=obs_std_npath,
                         _["apprx_npath"]=app_npath,_["apprx_std_npath"]=app_std_npath,
                         _["p_value"]=p_value,_["p_std_value"]=p_std_value);
   }
 }
 
 // omni_mis_DFSANE
 List omni_mis_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int npathsave);
 RcppExport SEXP _afttest_omni_mis_DFSANE(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(omni_mis_DFSANE(npath, b, time, delta, covariates, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // omni_mns_DFSANE
 List omni_mns_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int npathsave);
 RcppExport SEXP _afttest_omni_mns_DFSANE(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(omni_mns_DFSANE(npath, b, time, delta, covariates, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // link_mis_DFSANE
 List link_mis_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int npathsave);
 RcppExport SEXP _afttest_link_mis_DFSANE(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(link_mis_DFSANE(npath, b, time, delta, covariates, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // link_mns_DFSANE
 List link_mns_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int npathsave);
 RcppExport SEXP _afttest_link_mns_DFSANE(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(link_mns_DFSANE(npath, b, time, delta, covariates, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // form_mis_DFSANE
 List form_mis_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int cov_tested, int npathsave);
 RcppExport SEXP _afttest_form_mis_DFSANE(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP cov_testedSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< int >::type cov_tested(cov_testedSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(form_mis_DFSANE(npath, b, time, delta, covariates, cov_tested, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // form_mns_DFSANE
 List form_mns_DFSANE(int npath, vec b, vec time, vec delta, mat covariates, int cov_tested, int npathsave);
 RcppExport SEXP _afttest_form_mns_DFSANE(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP cov_testedSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< int >::type cov_tested(cov_testedSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(form_mns_DFSANE(npath, b, time, delta, covariates, cov_tested, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // omni_mis_optim
 List omni_mis_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int npathsave);
 RcppExport SEXP _afttest_omni_mis_optim(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP optimTypeSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< String >::type optimType(optimTypeSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(omni_mis_optim(npath, b, time, delta, covariates, optimType, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // omni_mns_optim
 List omni_mns_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int npathsave);
 RcppExport SEXP _afttest_omni_mns_optim(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP optimTypeSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< String >::type optimType(optimTypeSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(omni_mns_optim(npath, b, time, delta, covariates, optimType, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // link_mis_optim
 List link_mis_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int npathsave);
 RcppExport SEXP _afttest_link_mis_optim(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP optimTypeSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< String >::type optimType(optimTypeSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(link_mis_optim(npath, b, time, delta, covariates, optimType, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // link_mns_optim
 List link_mns_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int npathsave);
 RcppExport SEXP _afttest_link_mns_optim(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP optimTypeSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< String >::type optimType(optimTypeSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(link_mns_optim(npath, b, time, delta, covariates, optimType, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // form_mis_optim
 List form_mis_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int cov_tested, int npathsave);
 RcppExport SEXP _afttest_form_mis_optim(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP optimTypeSEXP, SEXP cov_testedSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< String >::type optimType(optimTypeSEXP);
   Rcpp::traits::input_parameter< int >::type cov_tested(cov_testedSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(form_mis_optim(npath, b, time, delta, covariates, optimType, cov_tested, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 // form_mns_optim
 List form_mns_optim(int npath, vec b, vec time, vec delta, mat covariates, String optimType, int cov_tested, int npathsave);
 RcppExport SEXP _afttest_form_mns_optim(SEXP npathSEXP, SEXP bSEXP, SEXP TimeSEXP, SEXP DeltaSEXP, SEXP CovariSEXP, SEXP optimTypeSEXP, SEXP cov_testedSEXP, SEXP npathsaveSEXP) {
   BEGIN_RCPP
   Rcpp::RObject rcpp_result_gen;
   Rcpp::RNGScope rcpp_rngScope_gen;
   Rcpp::traits::input_parameter< int >::type npath(npathSEXP);
   Rcpp::traits::input_parameter< vec >::type b(bSEXP);
   Rcpp::traits::input_parameter< vec >::type time(TimeSEXP);
   Rcpp::traits::input_parameter< vec >::type delta(DeltaSEXP);
   Rcpp::traits::input_parameter< mat >::type covariates(CovariSEXP);
   Rcpp::traits::input_parameter< String >::type optimType(optimTypeSEXP);
   Rcpp::traits::input_parameter< int >::type cov_tested(cov_testedSEXP);
   Rcpp::traits::input_parameter< int >::type npathsave(npathsaveSEXP);
   rcpp_result_gen = Rcpp::wrap(form_mns_optim(npath, b, time, delta, covariates, optimType, cov_tested, npathsave));
   return rcpp_result_gen;
   END_RCPP
 }
 
 static const R_CallMethodDef CallEntries[] = {
   {"_afttest_omni_mis_DFSANE", (DL_FUNC) &_afttest_omni_mis_DFSANE, 6},
   {"_afttest_omni_mns_DFSANE", (DL_FUNC) &_afttest_omni_mns_DFSANE, 6},
   {"_afttest_link_mis_DFSANE", (DL_FUNC) &_afttest_link_mis_DFSANE, 6},
   {"_afttest_link_mns_DFSANE", (DL_FUNC) &_afttest_link_mns_DFSANE, 6},
   {"_afttest_form_mis_DFSANE", (DL_FUNC) &_afttest_form_mis_DFSANE, 7},
   {"_afttest_form_mns_DFSANE", (DL_FUNC) &_afttest_form_mns_DFSANE, 7},
   {"_afttest_omni_mis_optim", (DL_FUNC) &_afttest_omni_mis_optim, 7},
   {"_afttest_omni_mns_optim", (DL_FUNC) &_afttest_omni_mns_optim, 7},
   {"_afttest_link_mis_optim", (DL_FUNC) &_afttest_link_mis_optim, 7},
   {"_afttest_link_mns_optim", (DL_FUNC) &_afttest_link_mns_optim, 7},
   {"_afttest_form_mis_optim", (DL_FUNC) &_afttest_form_mis_optim, 8},
   {"_afttest_form_mns_optim", (DL_FUNC) &_afttest_form_mns_optim, 8},
   {NULL, NULL, 0}
 };
 
 RcppExport void R_init_afttest(DllInfo *dll) {
   R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
   R_useDynamicSymbols(dll, FALSE);
 }
