% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesianWAgg.R
\name{BayesianWAgg}
\alias{BayesianWAgg}
\title{Aggregation Method: BayesianWAgg}
\usage{
BayesianWAgg(
  expert_judgements,
  type = "BayTriVar",
  priors = NULL,
  name = NULL,
  placeholder = FALSE,
  percent_toggle = FALSE,
  round_2_filter = TRUE
)
}
\arguments{
\item{expert_judgements}{A dataframe in the format of \link{data_ratings}.}

\item{type}{One of \code{"BayTriVar"}, or \code{"BayPRIORsAgg"}.}

\item{priors}{(Optional) A dataframe of priors in the format of \link{data_supp_priors}, required for \code{type} \code{BayPRIORsAgg}.}

\item{name}{Name for aggregation method. Defaults to \code{type} unless specified.}

\item{placeholder}{Toggle the output of the aggregation method to impute placeholder data.}

\item{percent_toggle}{Change the values to probabilities. Default is \code{FALSE}.}

\item{round_2_filter}{Note that the IDEA protocol results in both a Round 1
and Round 2 set of probabilities for each claim. Unless otherwise specified,
we will assume that the final Round 2 responses (after discussion) are being
referred to.}
}
\value{
A tibble of confidence scores \code{cs} for each \code{paper_id}.
}
\description{
Bayesian aggregation methods with either uninformative or informative prior distributions.

\strong{JAGS Install}

For instructions on installing JAGS onto your system visit \url{https://gist.github.com/dennisprangle/e26923fae7477566510757ab3341f54c}
}
\details{
\code{type} may be one of the following:

\strong{BayTriVar}: The Bayesian Triple-Variability Method, fit with JAGS.

\loadmathjax
Three kinds of variability around best estimates are considered:
\enumerate{
\item generic claim variability: variation across individuals within a claim
\item generic participant variability: variation within an individual across claims
\item claim - participant specific uncertainty (operationalised by bounds): informed
by interval widths given by individual \mjeqn{i}{ascii} for claim \mjeqn{c}{ascii}.
}

The model takes the log odds transformed individual best estimates as input (data),
uses a normal likelihood function and derives a posterior distribution for the
probability of replication.

\mjdeqn{log( \frac{B_{i,c}}{1-B_{i,c}}) \sim N(\mu_c, \sigma_{i,c}),}{ascii}

where \mjeqn{\mu_c}{ascii} denotes the mean estimated probability of replication for claim
\mjeqn{c}{ascii}, and  \mjeqn{\sigma_{i,c}}{ascii} denotes the standard deviation of the
estimated probability of replication for claim \mjeqn{c}{ascii} and individual
\mjeqn{i}{ascii} (on the logit scale).  Parameter \mjeqn{\sigma_{i,c}}{ascii} is calculated as:
\mjdeqn{\sigma_{i,c} = (U_{i,c} - L_{i,c} + 0.01) \times \sqrt{\sigma_i^2+\sigma_c^2}}{ascii}
with \mjeqn{\sigma_i}{ascii} denoting the standard deviation of estimated probabilities of
replication for individual \mjeqn{i}{ascii} and  \mjeqn{\sigma_c}{ascii} denoting the standard
deviation of the estimated probability of replication for claim \mjeqn{c}{ascii}.

The uninformative priors for specifying this Bayesian model are
\mjeqn{\mu_c \sim N(0,\ 3)}{ascii}, \mjeqn{\sigma_i \sim U(0,\ 10)}{ascii} and
\mjeqn{\sigma_c \sim U(0,\ 10)}{ascii}. After obtaining the median of the posterior
distribution of \mjeqn{\mu_c}{ascii}, we can back transform to obtain
\mjeqn{\hat{p}_c}{ascii}:

\mjdeqn{\hat{p}_c\left( BayTriVar \right) = \frac{e^{\mu_c}}{1+e^{\mu_c}}}{ascii}

\strong{BayPRIORsAgg}: Priors derived from predictive models, updated with best estimates.

This method uses Bayesian updating to update a prior probability of
replication estimated from a predictive model with an aggregate of the individuals’ best
estimates for any given claim. Methodology is the same as \code{type} \code{"BayTriVar"} except an
informative prior is used for \mjeqn{\mu_c}{ascii}. Conceptually the parameters of the prior
distribution of \mjeqn{\mu_c}{ascii} are informed by the PRIORS model (Gould et al. 2021)
which is a multilevel logistic regression model that predicts the probability of
replication using attributes of the original study. However, any model providing predictions of
the probability of replication can be used to generate the required priors.
}
\section{Warning}{
Both \code{BayTriVar} and \code{BayPRIORsAgg} methods require a minimum of two claims for which judgements are supplied to \code{expert_judgements}. This is due to the mathematical definition of these aggregators: \code{BayesianWAgg} calculates the variance in best estimates across multiple claims as well as the variance in best estimates across claims per individual. Thus when only one claim is provided in \code{expert_judgements}, the variance is 0, hence more than one claim is required for the successful execution of both Bayesian methods.
}

\examples{
\dontrun{BayesianWAgg(data_ratings)}

}
