% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtremisationWAgg.R
\name{ExtremisationWAgg}
\alias{ExtremisationWAgg}
\title{Aggregation Method: ExtremisationWAgg}
\usage{
ExtremisationWAgg(
  expert_judgements,
  type = "BetaArMean",
  name = NULL,
  alpha = 6,
  beta = 6,
  cutoff_lower = NULL,
  cutoff_upper = NULL,
  placeholder = FALSE,
  percent_toggle = FALSE,
  round_2_filter = TRUE
)
}
\arguments{
\item{expert_judgements}{A dataframe in the format of \link{data_ratings}.}

\item{type}{One of \code{"BetaArMean"} or \code{"BetaArMean2"}.}

\item{name}{Name for aggregation method. Defaults to \code{type} unless specified.}

\item{alpha}{parameter for the 'shape1' argument in the \code{stats::pbeta} function (defaults to 6)}

\item{beta}{parameter for the 'shape2' argument in the \code{stats::pbeta} function (defaults to 6)}

\item{cutoff_lower}{Lower bound of middle region without extremisation in \code{"BetaArMean2"} aggregation \code{type}s.}

\item{cutoff_upper}{Upper bound of middle region without extremisation in \code{"BetaArMean2"} aggregation \code{type}s.}

\item{placeholder}{Toggle the output of the aggregation method to impute placeholder data.}

\item{percent_toggle}{Change the values to probabilities. Default is \code{FALSE}.}

\item{round_2_filter}{Note that the IDEA protocol results in both a Round 1
and Round 2 set of probabilities for each claim. Unless otherwise specified,
we will assume that the final Round 2 responses (after discussion) are being
referred to.}
}
\value{
A tibble of confidence scores \code{cs} for each \code{paper_id}.
}
\description{
Calculate beta-transformed arithmetic means of best estimates.
}
\details{
This method takes the average of best estimates and transforms it using the cumulative
distribution function of a beta distribution.

\code{type} may be one of the following:

\strong{BetaArMean}: Beta transformation applied across the entire range of calculated confidence scores.
\loadmathjax

\mjdeqn{\hat{p}_c\left( \text{BetaArMean} \right) = H_{\alpha \beta}\left(\frac{1}{N} \sum_{i=1}^N B_{i,c} \right),}{ascii}

where \mjeqn{H_{\alpha \beta}}{ascii} is the cumulative distribution function of the beta distribution
with parameters \mjeqn{\alpha}{ascii} and \mjeqn{\beta}{ascii}, which default to 6 in the function.

The justification for equal parameters (the 'shape1' and 'shape2' arguments in the \code{stats::pbeta} function)
are outlined in Satopää et al (2014) and the references therein (note that the method outlined in that paper
is called a beta-transformed linear opinion pool).
To decide on the default shape value of \code{6}, we explored the \code{data_ratings} dataset with random subsets of 5 assessments per claim,
which we expect to have for most of the claims assessed by repliCATS.

\strong{BetaArMean2}: Beta transformation applied only to calculated confidence scores that are outside a specified middle range. The premise being that we don't extremise "fence-sitter" confidence scores.

\mjdeqn{\hat{p}_c\left( \text{BetaArMean2} \right) = \begin{cases}
\displaystyle H_{\alpha \beta}\left(\frac{1}{N} \sum_{i=1}^N B_{i,c} \right), \text{ for } \frac{1}{N} \sum_{i=1}^N B_{i,c} < \textit{cutoff\_lower} \cr
\displaystyle \frac{1}{N} \sum_{i=1}^N B_{i,c}, \text{ for } \textit{cutoff\_lower} \leq \frac{1}{N} \sum_{i=1}^N B_{i,c} \leq \textit{cutoff\_upper} \cr
\displaystyle H_{\alpha \beta}\left(\frac{1}{N} \sum_{i=1}^N B_{i,c} \right), \text{ for } \frac{1}{N} \sum_{i=1}^N B_{i,c} > \textit{cutoff\_upper} \cr
\end{cases}}{ascii}
}
\examples{
\donttest{ExtremisationWAgg(data_ratings)}

}
