% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_reason2.R
\name{weight_reason2}
\alias{weight_reason2}
\title{Weighting method: Total number and diversity of judgement reasons}
\usage{
weight_reason2(expert_reasons)
}
\arguments{
\item{expert_reasons}{A dataframe in the form of \link{data_supp_reasons}}
}
\value{
A tibble of three columns \code{paper_id}, \code{user_name}, and \code{reason_count}
}
\description{
This function is used by \link{ReasoningWAgg} to calculate weights for the aggregation
type \code{"ReasonWAgg2"}. Weights are based on the number and diversity of reasoning
methods used by the participant to support their judgement.
}
\details{
\loadmathjax
An individual's weight is a product of the number of reasons given in support of
their judgement and the diversity of these reasons.
\mjdeqn{w\_{varReason}_{i,c} =\sum_{r=1}^{R} \mathbf{CR_i}(c,r) \cdot (1 - \frac{\sum_{c=1}^C
\mathbf{CR_i}(c,r)}{C})}{ascii}
}
