% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_human.R
\name{plot_diff_human_aipw}
\alias{plot_diff_human_aipw}
\title{Visualize Difference in Risk (Human+AI v. Human)}
\usage{
plot_diff_human_aipw(
  Y,
  D,
  Z,
  V = NULL,
  l01 = 1,
  nuis_funcs = NULL,
  true.pscore = NULL,
  subgroup1,
  subgroup2,
  label.subgroup1 = "Subgroup 1",
  label.subgroup2 = "Subgroup 2",
  x.order = NULL,
  p.title = NULL,
  p.lb = -1,
  p.ub = 1,
  y.lab = "Impact of PSA",
  p.label = c("PSA harms", "PSA helps")
)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{V}{A matrix of pretreatment covariates (numeric matrix). Optional.}

\item{l01}{Ratio of the loss between false positives and false negatives. Default 1.}

\item{nuis_funcs}{output from \code{\link{compute_nuisance_functions}}. If NULL, the function will compute the nuisance functions using the provided data. Note that \code{V} must be provided if \code{nuis_funcs} is NULL.}

\item{true.pscore}{A vector of true propensity scores (numeric), if available. Optional.}

\item{subgroup1}{A pretreatment covariate used for subgroup analysis (vector).}

\item{subgroup2}{A pretreatment covariate used for subgroup analysis (vector).}

\item{label.subgroup1}{A label for subgroup1 (character). Default "Subgroup 1".}

\item{label.subgroup2}{A label for subgroup2 (character). Default "Subgroup 2".}

\item{x.order}{An order for the x-axis (character vector). Default NULL.}

\item{p.title}{A title for the plot (character). Default NULL.}

\item{p.lb}{A lower bound for the y-axis (numeric). Default -1.}

\item{p.ub}{An upper bound for the y-axis (numeric). Default 1.}

\item{y.lab}{A label for the y-axis (character). Default "Impact of PSA".}

\item{p.label}{A vector of two labels for the annotations (character). Default c("PSA harms", "PSA helps").}
}
\value{
A ggplot object.
}
\description{
Visualize the difference in risk between human+AI and human decision makers using AIPW estimators.
Generate a plot based on the overall agreement and subgroup-specific agreement.
}
\examples{
plot_diff_human_aipw(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  nuis_funcs = nuis_func,
  true.pscore = rep(0.5, nrow(NCAdata)),
  l01 = 1,
  subgroup1 = ifelse(NCAdata$White == 1, "White", "Non-white"),
  subgroup2 = ifelse(NCAdata$Sex == 1, "Male", "Female"),
  label.subgroup1 = "Race",
  label.subgroup2 = "Gender",
  x.order = c("Overall", "Non-white", "White", "Female", "Male"),
  p.title = NULL, p.lb = -0.3, p.ub = 0.3
)

}
