% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareVGA.R
\name{makeVGAGraph}
\alias{makeVGAGraph}
\title{Create a graph between visible cells in the PointMap}
\usage{
makeVGAGraph(
  pointMap,
  boundaryGraph = FALSE,
  maxVisibility = NA,
  copyMap = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{pointMap}{The input PointMap}

\item{boundaryGraph}{Only create a graph on the boundary cells}

\item{maxVisibility}{Limit how far two cells can be to be connected}

\item{copyMap}{Optional. Copy the internal sala map}

\item{verbose}{Optional. Show more information of the process.}
}
\value{
A new PointMap with a graph between points
}
\description{
Create a graph between visible cells in the PointMap
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeMap <- as(sfMap[, vector()], "ShapeMap")
lineStringMap <- as(sfMap, "sf")
mapRegion <- sf::st_bbox(lineStringMap)
pointMap <- createGrid(
  minX = mapRegion[["xmin"]],
  minY = mapRegion[["ymin"]],
  maxX = mapRegion[["xmax"]],
  maxY = mapRegion[["ymax"]],
  gridSize = 0.5
)
pointMap <- blockLines(
  pointMap = pointMap,
  lineStringMap = lineStringMap[vector()]
)
pointMap <- fillGrid(
  pointMap = pointMap,
  fillX = 3.01,
  fillY = 6.7
)
makeVGAGraph(
  pointMap = pointMap,
  boundaryGraph = FALSE,
  maxVisibility = NA
)
}
