% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aou_connect.R
\name{aou_connect}
\alias{aou_connect}
\title{Create a connection to the database in All of Us}
\usage{
aou_connect(CDR = getOption("aou.default.cdr"), ...)
}
\arguments{
\item{CDR}{The name of the "curated data repository" to connect to. Defaults
to \code{getOption("aou.default.cdr")}, which is \code{Sys.getenv('WORKSPACE_CDR')}
if not specified otherwise (i.e., the "mainline" CDR). On the controlled
tier, specify the "base" CDR with \code{CDR = paste0(Sys.getenv('WORKSPACE_CDR'), "_base")}.}

\item{...}{Further arguments passed along to \code{DBI::dbConnect()}.}
}
\value{
A \code{BigQueryConnection} object. This object is also saved as an option
(\code{getOption("aou.default.con")}).
}
\description{
Connects to the All of Us database and returns a
BigQueryConnection object. You can reference this object to query the
database using R and or SQL code. A message is printed with the connection
status (successful or not).
}
\details{
You can reference this object to connect to the All of Us database
and run SQL code using, e.g., \code{dbplyr} or \code{DBI}. A message is printed with
the connection status (successful or not). For RStudio users, setting quiet = TRUE
will silence most (but not all) billing messages.
}
\examples{
\dontshow{if (on_workbench()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
con <- aou_connect()
# reference the observation table in the database
dplyr::tbl(con, "observation")
# print a list of the tables in the database
DBI::dbListTables(con)
\dontshow{\}) # examplesIf}
}
