% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{compare_target_category}
\alias{compare_target_category}
\title{Comparison of categorical variables of train set and test set}
\usage{
compare_target_category(.data, ..., add_character = FALSE, margin = FALSE)
}
\arguments{
\item{.data}{an object of class "split_df", usually, a result of a call to split_df().}

\item{...}{one or more unquoted expressions separated by commas.
Select the categorical variable you want to compare.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, compare_target_category() will automatically
start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}

\item{add_character}{logical. Decide whether to include text variables in the
compare of categorical data. The default value is FALSE, which also not includes character variables.}

\item{margin}{logical. Choose to calculate the marginal frequency information.}
}
\value{
tbl_df.
Variables of tbl_df for comparison:
\itemize{
\item variable : character. categorical variable name
\item level : factor. level of categorical variables
\item train : numeric. the relative frequency of the level in the train set
\item test : numeric. the relative frequency of the level in the test set
\item abs_diff : numeric. the absolute value of the difference between two
relative frequencies
}
}
\description{
Compare the statistics of the categorical variables of
the train set and test set included in the "split_df" class.
}
\details{
Compare the statistics of the numerical variables of the train set and
the test set to determine whether the raw data is well separated into two data sets.
}
\examples{
library(dplyr)

# Credit Card Default Data
head(ISLR::Default)

# Generate data for the example
sb <- ISLR::Default \%>\%
  split_by(default)

sb \%>\%
  compare_target_category()

sb \%>\%
  compare_target_category(add_character = TRUE)

sb \%>\%
  compare_target_category(margin = TRUE)

sb \%>\%
  compare_target_category(student)

sb \%>\%
  compare_target_category(student, margin = TRUE)

}
