% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routing.R
\name{Routing}
\alias{Routing}
\title{Core Routing Class}
\value{
A Routing object.
}
\description{
Core routing class.
Do not use directly, see \link{Ambiorix}, and \link{Router}.
}
\examples{

## ------------------------------------------------
## Method `Routing$get`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Routing$param`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req,res){
 res$send("Hello!")
})

app$param("person", function(req, res, value, name){
 if(value == "notWanted"){
  res$status <- 403L
  res$send("This is the end.")
 }

 # continue processing the request...
})

app$get("/hi/:person", function(req,res){
 res$sendf("Hi! \%s", req$params$person)
})
app$get("/info/:person", function(req,res){
 res$sendf("Here is all your info, \%s", req$params$person)
})
if(interactive())
 app$start()

## ------------------------------------------------
## Method `Routing$receive`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

app$receive("hello", function(msg, ws){
 print(msg) # print msg received

 # send a message back
 ws$send("hello", "Hello back! (sent from R)")
})

if(interactive())
 app$start()
}
\keyword{export}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{error}}{Error handler.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{basepath}}{Basepath, read-only.}

\item{\code{websocket}}{Websocket handler.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Routing-new}{\code{Routing$new()}}
\item \href{#method-Routing-get}{\code{Routing$get()}}
\item \href{#method-Routing-put}{\code{Routing$put()}}
\item \href{#method-Routing-patch}{\code{Routing$patch()}}
\item \href{#method-Routing-delete}{\code{Routing$delete()}}
\item \href{#method-Routing-post}{\code{Routing$post()}}
\item \href{#method-Routing-options}{\code{Routing$options()}}
\item \href{#method-Routing-all}{\code{Routing$all()}}
\item \href{#method-Routing-param}{\code{Routing$param()}}
\item \href{#method-Routing-receive}{\code{Routing$receive()}}
\item \href{#method-Routing-print}{\code{Routing$print()}}
\item \href{#method-Routing-engine}{\code{Routing$engine()}}
\item \href{#method-Routing-use}{\code{Routing$use()}}
\item \href{#method-Routing-get_routes}{\code{Routing$get_routes()}}
\item \href{#method-Routing-get_params}{\code{Routing$get_params()}}
\item \href{#method-Routing-get_receivers}{\code{Routing$get_receivers()}}
\item \href{#method-Routing-get_middleware}{\code{Routing$get_middleware()}}
\item \href{#method-Routing-prepare}{\code{Routing$prepare()}}
\item \href{#method-Routing-clone}{\code{Routing$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-new"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$new(path = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Prefix path.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-get"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-get}{}}}
\subsection{Method \code{get()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$get(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
GET Method

Add routes to listen to.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-put"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-put}{}}}
\subsection{Method \code{put()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$put(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
PUT Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-patch"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-patch}{}}}
\subsection{Method \code{patch()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$patch(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
PATCH Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-delete}{}}}
\subsection{Method \code{delete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$delete(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to, \code{:} defines a parameter.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
DELETE Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-post"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-post}{}}}
\subsection{Method \code{post()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$post(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
POST Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-options"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-options}{}}}
\subsection{Method \code{options()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$options(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
OPTIONS Method

Add routes to listen to.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-all"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-all}{}}}
\subsection{Method \code{all()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$all(path, handler, error = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Route to listen to.}

\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}

\item{\code{error}}{Handler function to run on error.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
All Methods

Add routes to listen to for all methods \code{GET}, \code{POST}, \code{PUT}, \code{DELETE}, and \code{PATCH}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-param"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-param}{}}}
\subsection{Method \code{param()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$param(name, handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the parameter}

\item{\code{handler}}{Function that accepts the request, response, parameter value and the parameter name.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
PARAM Method
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req,res){
 res$send("Hello!")
})

app$param("person", function(req, res, value, name){
 if(value == "notWanted"){
  res$status <- 403L
  res$send("This is the end.")
 }

 # continue processing the request...
})

app$get("/hi/:person", function(req,res){
 res$sendf("Hi! \%s", req$params$person)
})
app$get("/info/:person", function(req,res){
 res$sendf("Here is all your info, \%s", req$params$person)
})
if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-receive"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$receive(name, handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of message.}

\item{\code{handler}}{Function to run when message is received.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Receive Websocket Message
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

app$receive("hello", function(msg, ws){
 print(msg) # print msg received

 # send a message back
 ws$send("hello", "Hello back! (sent from R)")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-print"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-engine"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-engine}{}}}
\subsection{Method \code{engine()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$engine(engine)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{engine}}{Engine function.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Engine to use for rendering templates.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-use"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-use}{}}}
\subsection{Method \code{use()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$use(use)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use}}{Either a router as returned by \link{Router}, a function to use as middleware,
or a \code{list} of functions.
If a function is passed, it must accept two arguments (the request, and the response):
this function will be executed every time the server receives a request.
\emph{Middleware may but does not have to return a response, unlike other methods such as \code{get}}
Note that multiple routers and middlewares can be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Use a router or middleware
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-get_routes"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-get_routes}{}}}
\subsection{Method \code{get_routes()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$get_routes(routes = list(), parent = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{routes}}{Existing list of routes.}

\item{\code{parent}}{Parent path.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Get the routes
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-get_params"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-get_params}{}}}
\subsection{Method \code{get_params()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$get_params(params = list(), parent = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Existing list of parameter middlewares.}

\item{\code{parent}}{Parent path.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Get the parameter middlewares
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-get_receivers"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-get_receivers}{}}}
\subsection{Method \code{get_receivers()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$get_receivers(receivers = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{receivers}}{Existing list of receivers}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Get the websocket receivers
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-get_middleware"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-get_middleware}{}}}
\subsection{Method \code{get_middleware()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$get_middleware(middlewares = list(), parent = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{middlewares}}{Existing list of middleswares}

\item{\code{parent}}{Parent path}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Get the middleware
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-prepare"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-prepare}{}}}
\subsection{Method \code{prepare()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$prepare()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Prepare routes and decomposes paths
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Routing-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Routing-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Routing$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
