% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{simulate_AMS}
\alias{simulate_AMS}
\title{simulate_AMS
Monte Carlo simulation of price paths under:
1 = Black–Scholes (exact solution)
2 = Heston (Euler discretisation)
3 = Heston (Milstein discretisation)
4 = Heston (Quadratic–Exponential scheme, Andersen 2008)}
\usage{
simulate_AMS(model, n, t, p, r, sigma, S0, rho = NULL, rim = 0L, v0 = 0.04)
}
\arguments{
\item{model}{Integer in \eqn{\{1,2,3,4\}} selecting the model.}

\item{n}{Number of simulated paths (>0).}

\item{t}{Maturity in years (>0).}

\item{p}{Total time steps (>0).}

\item{r}{Risk–free rate.}

\item{sigma}{Black–Scholes volatility (>=0, used only when \code{model == 1}).}

\item{S0}{Initial spot price (>0).}

\item{rho}{Correlation between asset and variance Brownian motions (required for Heston models, finite in \eqn{[-1,1]}).}

\item{rim}{Left–trim: discard the first \code{rim} time steps (0 <= rim < p). Returned matrices keep \code{p - rim + 1} columns including the initial time.}

\item{v0}{Initial variance for Heston models (>=0).}
}
\value{
List: for model 1 returns \code{S} (\eqn{n \times (p-rim+1)}); for Heston models returns \code{S} and \code{V}.
}
\description{
simulate_AMS
Monte Carlo simulation of price paths under:
1 = Black–Scholes (exact solution)
2 = Heston (Euler discretisation)
3 = Heston (Milstein discretisation)
4 = Heston (Quadratic–Exponential scheme, Andersen 2008)
}
\examples{
\donttest{
  b <- simulate_AMS(1, n = 50, t = 1, p = 10, r = 0.01, sigma = 0.2, S0 = 100, rho = NULL)
  str(b)
}
}
