% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/c14_uncalibrate.R
\docType{methods}
\name{c14_uncalibrate}
\alias{c14_uncalibrate}
\alias{c14_uncalibrate-method}
\alias{c14_uncalibrate,numeric-method}
\alias{c14_uncalibrate,CalibratedAges-method}
\title{Uncalibrate a Radiocarbon Date}
\usage{
c14_uncalibrate(object, ...)

\S4method{c14_uncalibrate}{numeric}(object, curves = "intcal20")

\S4method{c14_uncalibrate}{CalibratedAges}(object, n = 10000, rounding = getOption("ananke.round"), ...)
}
\arguments{
\item{object}{A \code{\linkS4class{CalibratedAges}} object or a \code{\link{numeric}} vector of
calibrated ages (in years BP).}

\item{...}{Currently not used.}

\item{curves}{A \code{\link{character}} vector specifying the calibration curve to be
used. Different curves can be specified.}

\item{n}{An \code{\link{integer}} specifying the number of random samples.}

\item{rounding}{A \code{\link{character}} string specifying the rounding convention.
It can be one of "\code{none}" (the default, no rounding) or "\code{stuiver}".
Any unambiguous substring can be given.}
}
\description{
Uncalibrate a Radiocarbon Date
}
\examples{
\donttest{
## Calibrate multiple dates
cal <- c14_calibrate(
  values = c(5000, 4500),
  errors = c(45, 35),
  names = c("X", "Y")
)

## Uncalibrate
c14_uncalibrate(cal, rounding = "stuiver")
}
}
\seealso{
Other radiocarbon tools: 
\code{\link{F14C}},
\code{\link{c14_calibrate}()},
\code{\link{c14_combine}()},
\code{\link{c14_curve}()},
\code{\link{c14_ensemble}()},
\code{\link{c14_plot}},
\code{\link{c14_sample}()},
\code{\link{c14_spd}()},
\code{\link{rec_plot}}
}
\author{
N. Frerebeau
}
\concept{radiocarbon tools}
