% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/describe.R
\docType{methods}
\name{describe}
\alias{describe}
\alias{describe,CalibratedAges-method}
\title{Data Description}
\usage{
\S4method{describe}{CalibratedAges}(x, calendar = get_calendar(), level = 0.954, ...)
}
\arguments{
\item{x}{A \code{\linkS4class{CalibratedAges}} object.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}).}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{...}{Further parameters to be passed to \code{\link[=cat]{cat()}}.}
}
\value{
\code{describe()} is called for its side-effects. Invisibly returns \code{x}.
}
\description{
Data Description
}
\examples{
## Calibrate multiple dates
cal <- c14_calibrate(
  values = c(5000, 4500),
  errors = c(45, 35),
  names = c("X", "Y")
)

## Full text description
describe(cal)
}
\references{
Millard, A. R. (2014). Conventions for Reporting Radiocarbon Determinations.
\emph{Radiocarbon}, 56(2): 555-559. \doi{10.2458/56.17455}.
}
\author{
N. Frerebeau
}
\concept{summary}
