% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RES.R
\name{activateRES}
\alias{activateRES}
\title{Activate RES in an Antares study}
\usage{
activateRES(opts = antaresRead::simOptions(), quietly = !interactive())
}
\arguments{
\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}

\item{quietly}{Display or not a message to the user if success.}
}
\value{
An updated list containing various information about the simulation.
}
\description{
Helper to activate Renewables Energy Sources. This will
update \code{renewable.generation.modelling} parameter and create
appropriate structure for RES clusters.
}
\examples{
\dontrun{

library(antaresEditObject)
tmp <- tempfile()
createStudy(path = tmp)
opts <- antaresRead::setSimulationPath(tmp)
activateRES()

# then you can use createClusterRES()...

}
}
