% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{apa_parameters}
\alias{apa_parameters}
\alias{apa_parameters.lm}
\alias{apa_parameters.list}
\title{format model parameters in APA style}
\usage{
apa_parameters(
  fit,
  predictor_parameters = c("Coefficient", "SE", "Std_Coefficient", "t", "df_error", "p"),
  starred = NULL,
  bolded = NULL,
  column_formats = NULL,
  t_with_df = TRUE
)

\method{apa_parameters}{lm}(
  fit,
  predictor_parameters = c("Parameter", "Coefficient", "SE", "Std_Coefficient", "t",
    "df_error", "p"),
  starred = NA,
  bolded = NA,
  column_formats = NULL,
  t_with_df = TRUE
)

\method{apa_parameters}{list}(
  fit,
  predictor_parameters = c("Parameter", "Coefficient", "SE", "Std_Coefficient", "t",
    "df_error", "p"),
  starred = NA,
  bolded = NA,
  column_formats = NULL,
  t_with_df = TRUE
)
}
\arguments{
\item{fit}{model fit object}

\item{predictor_parameters}{predictor parameters to display. If named vector, column names will be vector names}

\item{starred}{columns to star with significant p_values}

\item{bolded}{columns to bold, if significant}

\item{column_formats}{column_formats object to format columns. If NULL, the default column_formats is used.}

\item{t_with_df}{if TRUE, the t column will be displayed with degrees of freedom in parentheses. If FALSE, only the t value is displayed.}
}
\value{
tibble
}
\description{
format model parameters in APA style
}
\examples{
lm(mpg ~ cyl + wt, data = mtcars) |>
   apa_parameters() |>
   apa_flextable()
}
