% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsimx_soil_profile.R
\name{compare_apsim_soil_profile}
\alias{compare_apsim_soil_profile}
\alias{print.soil_profile_mrg}
\alias{plot.soil_profile_mrg}
\title{Compare two or more soil profiles}
\usage{
compare_apsim_soil_profile(
  ...,
  soil.var = c("all", "Thickness", "BD", "AirDry", "LL15", "DUL", "SAT", "KS", "Carbon",
    "SoilCNRatio", "FOM", "FOM.CN", "FBiom", "FInert", "NO3N", "NH4N", "PH",
    "ParticleSizeClay", "ParticleSizeSilt", "ParticleSizeSand"),
  property,
  labels,
  merge.wide = TRUE,
  check = FALSE,
  verbose = FALSE
)

\method{print}{soil_profile_mrg}(x, ..., format = c("wide", "long"), digits = 2)

\method{plot}{soil_profile_mrg}(
  x,
  ...,
  plot.type = c("depth", "vs", "diff", "density"),
  pairs = NULL,
  soil.var = c("all", "Thickness", "BD", "AirDry", "LL15", "DUL", "SAT", "KS", "Carbon",
    "SoilCNRatio", "FOM", "FOM.CN", "FBiom", "FInert", "NO3N", "NH4N", "PH",
    "ParticleSizeClay", "ParticleSizeSilt", "ParticleSizeSand"),
  property,
  span = 0.75
)
}
\arguments{
\item{...}{\sQuote{soil_profile} objects. Should be of class \sQuote{soil_profile}}

\item{soil.var}{soil variable to plot}

\item{property}{same as soil.var}

\item{labels}{labels for plotting and identification of \sQuote{soil_profile} objects.}

\item{merge.wide}{whether to attempt to merge soils in \sQuote{wide} format.}

\item{check}{whether to check \sQuote{soil_profile} objects using \sQuote{check_apsimx_soil_profile}.}

\item{verbose}{whether to print agreement values (default is FALSE).}

\item{x}{object of class \sQuote{soil_profile_mrg}}

\item{format}{either \sQuote{wide} or \sQuote{long}, which depends on the merging.}

\item{digits}{number of digits to print (default is 2)}

\item{plot.type}{either \sQuote{depth}, \sQuote{vs}, \sQuote{diff} or \sQuote{density}}

\item{pairs}{pair of objects to compare, defaults to 1 and 2 but others are possible}

\item{span}{argument to be passed to \sQuote{geom_smooth}}
}
\value{
object of class \sQuote{soil_profile_mrg}, which can be used for further plotting

a table with indexes for the soil profiles

it produces a plot
}
\description{
Helper function which allows for a simple comparison among soil_profile objects

print method for \sQuote{soil_profile_mrg}

plotting function for compare_apsim_soil_profile, it requires ggplot2
}
\note{
I have only tested this for 2 or 3 objects. The code is set up to be able to 
compare more, but I'm not sure that would be all that useful.
}
\examples{
\dontrun{
require(soilDB)
require(sp)
require(sf)
require(spData)
# Get two soil profiles
sp1 <- get_ssurgo_soil_profile(lonlat = c(-93, 42))
sp2 <- get_ssurgo_soil_profile(lonlat = c(-92, 41))
# Compare them
cmp <- compare_apsim_soil_profile(sp1[[1]], sp2[[1]], labels = c("sp1", "sp2"))
# Plot the variables
plot(cmp)
}

}
