% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_hypothesis_test.R
\name{argmin.HT.MT}
\alias{argmin.HT.MT}
\title{Perform argmin hypothesis test.}
\usage{
argmin.HT.MT(difference.matrix, sample.mean = NULL, test = "z", alpha = 0.05)
}
\arguments{
\item{difference.matrix}{A n by (p-1) difference data matrix (reference dimension - the rest);
each of its row is a (p-1)-dimensional vector of differences.}

\item{sample.mean}{The sample mean of differences; defaults to NULL. It can be calculated via colMeans(difference.matrix).}

\item{test}{The test to perform: 't' or 'z'; defaults to 'z'.
If the data are assumed normally distributed, use 't'; otherwise 'z'.}

\item{alpha}{The significance level of the hypothesis test; defaults to 0.05.}
}
\value{
A list containing:\tabular{ll}{
   \code{p.val} \tab p value without Bonferroni's correction. \cr
   \tab \cr
.   \code{critical.value} \tab The critical value for the hypothesis test. Being less than it leads to a rejection. \cr
   \tab \cr
   \code{ans} \tab 'Reject' or 'Accept' \cr
}
}
\description{
Test if a dimension may be argmin, using multiple testing with Bonferroni's correction.
}
