% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{hexToBits}
\alias{hexToBits}
\title{Convert Hexadecimal Digit to Integer Vector}
\usage{
hexToBits(hex)
}
\arguments{
\item{hex}{a vector of character values corresponding to a sequence of one or more
hexadecimal digits (i.e. \code{"0"} through \code{"9"},\code{"a"} through \code{"f"}, or \code{"A"} through \code{"F"}).}
}
\value{
An integer vector holding the bits as values 0 or 1.  The
inverse of 'mathematical' order is used, as is the case for the base
R function \code{\link[=rawToBits]{rawToBits()}}; see the \dQuote{Examples}.
}
\description{
\code{hexToBits} converts a string holding hexadecimal digits to a sequence of integers
0 or 1, for the bits.  This is mainly for for use within \code{\link[=showQCTests]{showQCTests()}}.
}
\examples{
library(argoFloats)
hexToBits("3") # 1 1 0 0
hexToBits("4000") # 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0

}
\author{
Jaimie Harbin and Dan Kelley
}
