% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_function_with_LLM.R
\name{summarise_function_with_LLM}
\alias{summarise_function_with_LLM}
\title{Summarize a function using a Large Language Model}
\usage{
summarise_function_with_LLM(
  foo_name,
  llm_api_url = Sys.getenv("LLM_API_URL"),
  llm_api_key = Sys.getenv("LLM_API_KEY"),
  envir = environment()
)
}
\arguments{
\item{foo_name}{function name}

\item{llm_api_url}{url to the API for the LLM}

\item{llm_api_key}{key for the API for the LLM}

\item{envir}{The environment in which to look for the function.}
}
\value{
A character string with a summary of the function based on its arguments and body.
}
\description{
This function summarizes another function using a Language Model.
}
\examples{
\dontrun{
summarise_function_with_LLM(foo_name = "get_active_functions",
                            llm_api_url = Sys.getenv("LLM_API_URL"),
                            llm_api_key = Sys.getenv("LLM_API_KEY"),
                            envir = rlang::ns_env("assertHE"))
}

}
