% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-string.R
\name{wrap_string}
\alias{wrap_string}
\title{Wrap a string to lines of a specified width}
\usage{
wrap_string(input_string, width = 80)
}
\arguments{
\item{input_string}{The input string to be wrapped.}

\item{width}{The maximum width of each line. Default is 80 characters.}
}
\value{
A character vector where each element represents a line of the
wrapped string.
}
\description{
This function takes an input string and wraps it to lines of a specified
width, breaking the string at word boundaries.
}
\examples{
input_string <- "This is a long string that needs to be wrapped to fit within
                a specified width."
wrapped_lines <- wrap_string(input_string, width = 30)
cat(wrapped_lines, sep = "\n")

}
