% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_compare.R
\name{assert_less_than}
\alias{assert_less_than}
\title{Assert input is less than some maximum value}
\usage{
assert_less_than(
  x,
  maximum,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object to check}

\item{maximum}{The maximum value to compare against (number)}

\item{msg}{A character string containing the error message to display if \code{x} is not less than the specified maximum value (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is less than the specified maximum value, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert a number is less than a specified maximum value.
To check all numbers in a vector / matrix are below a maximum value, see \code{\link[=assert_all_less_than]{assert_all_less_than()}}
}
\examples{
try({
assert_less_than(1, 2) # Passes
assert_less_than(1, 2) # Passes
assert_less_than(c(1,2,3), 4) # Throws error (Must be a number)
assert_less_than('A', 1) # Throws error (Must be a number)
assert_less_than(3, 2, msg = "custom error message") # Throws custom error
})

}
\concept{assert_comparison}
