% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-is}
\alias{node-is}
\alias{node_is_leaf}
\alias{node_is_named}
\alias{node_is_named_leaf}
\title{Get information on nodes}
\usage{
node_is_leaf(x)

node_is_named(x)

node_is_named_leaf(x)
}
\arguments{
\item{x}{A node, either from \code{\link[=tree_root]{tree_root()}} or from another \verb{node_*()}
function.}
}
\value{
A logical value.
}
\description{
Get information on whether a node is a leaf (meaning that it doesn't have
any children) and whether it is named.
}
\examples{
src <- "x <- rnorm(100, mean = 2)
    any(duplicated(y))
    x <- z + 1
    any(duplicated(x))"

root <- src |>
  tree_new() |>
  tree_root()

node_is_leaf(root)

root |>
  node_find(ast_rule(pattern = "z")) |>
  node_is_leaf()

root |>
  node_find(ast_rule(pattern = "z")) |>
  node_is_named()
}
