% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_top_anomalies}
\alias{get_top_anomalies}
\title{Get Top Anomalous Records}
\usage{
get_top_anomalies(scored_data, n = 100)
}
\arguments{
\item{scored_data}{A data frame with anomaly scores.}

\item{n}{Integer indicating the number of top records to return.
Default is 100.}
}
\value{
A data frame containing the top N most anomalous records,
  sorted by anomaly_score (descending).
}
\description{
Convenience function to extract the top N most anomalous records from
scored data.
}
\examples{
\donttest{
data <- data.frame(
  patient_id = 1:50,
  age = rnorm(50, 50, 15),
  cost = rnorm(50, 10000, 5000)
)
scored_data <- score_anomaly(data)
top_10 <- get_top_anomalies(scored_data, n = 10)
}
}
