% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.r
\name{reduce}
\alias{reduce}
\title{Remove relations not linked to the main relations}
\usage{
reduce(x, ...)
}
\arguments{
\item{x}{An object whose relations are to be filtered.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of the same class as \code{x}, with the auxiliary relations
and foreign key references removed.
}
\description{
Filters an object's relations, keeping only the main relations, and those
considered ancestors via foreign key references. Foreign key
references involving removed relations are also removed.
}
\details{
Details on how the main tables are chosen are given in individual methods.

This function is mostly intended for simplifying a database, or a database
schema, for the purposes of exploration, particularly by examining plots.
While the filtering might remove important auxiliary relations, it's also
likely to remove any based on spurious dependencies, of which some databases
can contain many.
}
\seealso{
\code{\link{reduce.database_schema}}, \code{\link{reduce.database}}.
}
